package zio.aws.sns.model
import zio.aws.sns.model.primitives.TopicARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Topic(topicArn: Optional[TopicARN] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.sns.model.Topic = {
    import Topic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.Topic
      .builder()
      .optionallyWith(
        topicArn.map(value => TopicARN.unwrap(value): java.lang.String)
      )(_.topicArn)
      .build()
  }
  def asReadOnly: zio.aws.sns.model.Topic.ReadOnly =
    zio.aws.sns.model.Topic.wrap(buildAwsValue())
}
object Topic {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sns.model.Topic] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.Topic =
      zio.aws.sns.model.Topic(topicArn.map(value => value))
    def topicArn: Optional[TopicARN]
    def getTopicArn: ZIO[Any, AwsError, TopicARN] =
      AwsError.unwrapOptionField("topicArn", topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.Topic
  ) extends zio.aws.sns.model.Topic.ReadOnly {
    override val topicArn: Optional[TopicARN] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.sns.model.primitives.TopicARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.Topic
  ): zio.aws.sns.model.Topic.ReadOnly = new Wrapper(impl)
}
