package zio.aws.sns.model
import zio.aws.sns.model.primitives.SubscriptionARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UnsubscribeRequest(subscriptionArn: SubscriptionARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.UnsubscribeRequest = {
    import UnsubscribeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.UnsubscribeRequest
      .builder()
      .subscriptionArn(
        SubscriptionARN.unwrap(subscriptionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sns.model.UnsubscribeRequest.ReadOnly =
    zio.aws.sns.model.UnsubscribeRequest.wrap(buildAwsValue())
}
object UnsubscribeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.UnsubscribeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.UnsubscribeRequest =
      zio.aws.sns.model.UnsubscribeRequest(subscriptionArn)
    def subscriptionArn: SubscriptionARN
    def getSubscriptionArn: ZIO[Any, Nothing, SubscriptionARN] =
      ZIO.succeed(subscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.UnsubscribeRequest
  ) extends zio.aws.sns.model.UnsubscribeRequest.ReadOnly {
    override val subscriptionArn: SubscriptionARN =
      zio.aws.sns.model.primitives.SubscriptionARN(impl.subscriptionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.UnsubscribeRequest
  ): zio.aws.sns.model.UnsubscribeRequest.ReadOnly = new Wrapper(impl)
}
