package zio.aws.sns.model
import zio.aws.sns.model.primitives.{OTPCode, PhoneNumberString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VerifySmsSandboxPhoneNumberRequest(
    phoneNumber: PhoneNumberString,
    oneTimePassword: OTPCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest = {
    import VerifySmsSandboxPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest
      .builder()
      .phoneNumber(PhoneNumberString.unwrap(phoneNumber): java.lang.String)
      .oneTimePassword(OTPCode.unwrap(oneTimePassword): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sns.model.VerifySmsSandboxPhoneNumberRequest.ReadOnly =
    zio.aws.sns.model.VerifySmsSandboxPhoneNumberRequest.wrap(buildAwsValue())
}
object VerifySmsSandboxPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sns.model.VerifySmsSandboxPhoneNumberRequest =
      zio.aws.sns.model
        .VerifySmsSandboxPhoneNumberRequest(phoneNumber, oneTimePassword)
    def phoneNumber: PhoneNumberString
    def oneTimePassword: OTPCode
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumberString] =
      ZIO.succeed(phoneNumber)
    def getOneTimePassword: ZIO[Any, Nothing, OTPCode] =
      ZIO.succeed(oneTimePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest
  ) extends zio.aws.sns.model.VerifySmsSandboxPhoneNumberRequest.ReadOnly {
    override val phoneNumber: PhoneNumberString =
      zio.aws.sns.model.primitives.PhoneNumberString(impl.phoneNumber())
    override val oneTimePassword: OTPCode =
      zio.aws.sns.model.primitives.OTPCode(impl.oneTimePassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest
  ): zio.aws.sns.model.VerifySmsSandboxPhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
