package zio.aws.sns
import zio.aws.sns.model.primitives.AttributeValue.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.sns.model.primitives.{
  Action,
  AttributeName,
  PhoneNumber,
  AttributeValue,
  Delegate,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Account extends Subtype[String]
    type Account = zio.aws.sns.model.primitives.Account.Type
    object Action extends Subtype[String]
    type Action = zio.aws.sns.model.primitives.Action.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.sns.model.primitives.AmazonResourceName.Type
    object AttributeName extends Subtype[String]
    type AttributeName = zio.aws.sns.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue = zio.aws.sns.model.primitives.AttributeValue.Type
    object AuthenticateOnUnsubscribe extends Subtype[String]
    type AuthenticateOnUnsubscribe =
      zio.aws.sns.model.primitives.AuthenticateOnUnsubscribe.Type
    object Binary extends Subtype[Chunk[Byte]]
    type Binary = zio.aws.sns.model.primitives.Binary.Type
    object Delegate extends Subtype[String]
    type Delegate = zio.aws.sns.model.primitives.Delegate.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.sns.model.primitives.Endpoint.Type
    object Iso2CountryCode extends Subtype[String]
    type Iso2CountryCode = zio.aws.sns.model.primitives.Iso2CountryCode.Type
    object Label extends Subtype[String]
    type Label = zio.aws.sns.model.primitives.Label.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.sns.model.primitives.MaxItems.Type
    object MaxItemsListOriginationNumbers extends Subtype[Int]
    type MaxItemsListOriginationNumbers =
      zio.aws.sns.model.primitives.MaxItemsListOriginationNumbers.Type
    object Message extends Subtype[String]
    type Message = zio.aws.sns.model.primitives.Message.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.sns.model.primitives.MessageId.Type
    object MessageStructure extends Subtype[String]
    type MessageStructure = zio.aws.sns.model.primitives.MessageStructure.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.sns.model.primitives.NextToken.Type
    object OTPCode extends Subtype[String]
    type OTPCode = zio.aws.sns.model.primitives.OTPCode.Type
    object PhoneNumber extends Subtype[String]
    type PhoneNumber = zio.aws.sns.model.primitives.PhoneNumber.Type
    object PhoneNumberString extends Subtype[String]
    type PhoneNumberString = zio.aws.sns.model.primitives.PhoneNumberString.Type
    object Protocol extends Subtype[String]
    type Protocol = zio.aws.sns.model.primitives.Protocol.Type
    object Subject extends Subtype[String]
    type Subject = zio.aws.sns.model.primitives.Subject.Type
    object SubscriptionARN extends Subtype[String]
    type SubscriptionARN = zio.aws.sns.model.primitives.SubscriptionARN.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.sns.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.sns.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.sns.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.sns.model.primitives.Token.Type
    object TopicARN extends Subtype[String]
    type TopicARN = zio.aws.sns.model.primitives.TopicARN.Type
    object TopicName extends Subtype[String]
    type TopicName = zio.aws.sns.model.primitives.TopicName.Type
  }
  type ActionsList = List[Action]
  type BatchResultErrorEntryList = List[zio.aws.sns.model.BatchResultErrorEntry]
  type DelegatesList = List[Delegate]
  type ListOfEndpoints = List[zio.aws.sns.model.Endpoint]
  type ListOfPlatformApplications = List[zio.aws.sns.model.PlatformApplication]
  type ListString = List[String]
  type MapStringToString = Map[String, String]
  type MessageAttributeMap =
    Map[String, zio.aws.sns.model.MessageAttributeValue]
  type NumberCapabilityList = List[zio.aws.sns.model.NumberCapability]
  type PhoneNumberInformationList =
    List[zio.aws.sns.model.PhoneNumberInformation]
  type PhoneNumberList = List[PhoneNumber]
  type PublishBatchRequestEntryList =
    List[zio.aws.sns.model.PublishBatchRequestEntry]
  type PublishBatchResultEntryList =
    List[zio.aws.sns.model.PublishBatchResultEntry]
  type SMSSandboxPhoneNumberList = List[zio.aws.sns.model.SMSSandboxPhoneNumber]
  type SubscriptionAttributesMap = Map[AttributeName, AttributeValue]
  type SubscriptionsList = List[zio.aws.sns.model.Subscription]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.sns.model.Tag]
  type TopicAttributesMap = Map[AttributeName, AttributeValue]
  type TopicsList = List[zio.aws.sns.model.Topic]
}
