package zio.aws.sqs
import zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sqs.model.{
  CreateQueueResponse,
  UntagQueueResponse,
  ChangeMessageVisibilityBatchResponse,
  PurgeQueueRequest,
  ListQueuesRequest,
  DeleteQueueRequest,
  ReceiveMessageResponse,
  TagQueueRequest,
  DeleteMessageBatchRequest,
  ReceiveMessageRequest,
  ChangeMessageVisibilityResponse,
  RemovePermissionResponse,
  CreateQueueRequest,
  ListDeadLetterSourceQueuesResponse,
  GetQueueAttributesResponse,
  SendMessageBatchResponse,
  DeleteQueueResponse,
  ChangeMessageVisibilityBatchRequest,
  SendMessageBatchRequest,
  SendMessageRequest,
  ListQueuesResponse,
  DeleteMessageBatchResponse,
  AddPermissionResponse,
  DeleteMessageResponse,
  TagQueueResponse,
  SetQueueAttributesResponse,
  PurgeQueueResponse,
  GetQueueAttributesRequest,
  SetQueueAttributesRequest,
  UntagQueueRequest,
  SendMessageResponse,
  AddPermissionRequest,
  RemovePermissionRequest,
  ChangeMessageVisibilityRequest,
  GetQueueUrlResponse,
  ListQueueTagsResponse,
  ListDeadLetterSourceQueuesRequest,
  DeleteMessageRequest,
  ListQueueTagsRequest,
  GetQueueUrlRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.sqs.{
  SqsAsyncClientBuilder,
  SqsAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Sqs extends AspectSupport[Sqs] {
  val api: SqsAsyncClient
  def getQueueAttributes(
      request: zio.aws.sqs.model.GetQueueAttributesRequest
  ): IO[AwsError, zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly]
  def sendMessage(
      request: zio.aws.sqs.model.SendMessageRequest
  ): IO[AwsError, zio.aws.sqs.model.SendMessageResponse.ReadOnly]
  def listQueues(
      request: zio.aws.sqs.model.ListQueuesRequest
  ): ZStream[Any, AwsError, String]
  def listQueuesPaginated(
      request: zio.aws.sqs.model.ListQueuesRequest
  ): IO[AwsError, zio.aws.sqs.model.ListQueuesResponse.ReadOnly]
  def untagQueue(
      request: zio.aws.sqs.model.UntagQueueRequest
  ): IO[AwsError, Unit]
  def tagQueue(request: zio.aws.sqs.model.TagQueueRequest): IO[AwsError, Unit]
  def deleteMessage(
      request: zio.aws.sqs.model.DeleteMessageRequest
  ): IO[AwsError, Unit]
  def deleteMessageBatch(
      request: zio.aws.sqs.model.DeleteMessageBatchRequest
  ): IO[AwsError, zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly]
  def purgeQueue(
      request: zio.aws.sqs.model.PurgeQueueRequest
  ): IO[AwsError, Unit]
  def addPermission(
      request: zio.aws.sqs.model.AddPermissionRequest
  ): IO[AwsError, Unit]
  def listQueueTags(
      request: zio.aws.sqs.model.ListQueueTagsRequest
  ): IO[AwsError, zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly]
  def createQueue(
      request: zio.aws.sqs.model.CreateQueueRequest
  ): IO[AwsError, zio.aws.sqs.model.CreateQueueResponse.ReadOnly]
  def listDeadLetterSourceQueues(
      request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
  ): ZStream[Any, AwsError, String]
  def listDeadLetterSourceQueuesPaginated(
      request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
  ): IO[AwsError, ReadOnly]
  def getQueueUrl(
      request: zio.aws.sqs.model.GetQueueUrlRequest
  ): IO[AwsError, zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly]
  def removePermission(
      request: zio.aws.sqs.model.RemovePermissionRequest
  ): IO[AwsError, Unit]
  def receiveMessage(
      request: zio.aws.sqs.model.ReceiveMessageRequest
  ): IO[AwsError, zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly]
  def setQueueAttributes(
      request: zio.aws.sqs.model.SetQueueAttributesRequest
  ): IO[AwsError, Unit]
  def deleteQueue(
      request: zio.aws.sqs.model.DeleteQueueRequest
  ): IO[AwsError, Unit]
  def sendMessageBatch(
      request: zio.aws.sqs.model.SendMessageBatchRequest
  ): IO[AwsError, zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly]
  def changeMessageVisibilityBatch(
      request: zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest
  ): IO[
    AwsError,
    zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.ReadOnly
  ]
  def changeMessageVisibility(
      request: zio.aws.sqs.model.ChangeMessageVisibilityRequest
  ): IO[AwsError, Unit]
}
object Sqs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sqs] = customized(identity)
  def customized(
      customization: SqsAsyncClientBuilder => SqsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sqs] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SqsAsyncClientBuilder => SqsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sqs] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SqsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SqsAsyncClient, SqsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SqsAsyncClient, SqsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SqsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SqsImpl[R](
      override val api: SqsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sqs
      with AwsServiceBase[R] {
    override val serviceName: String = "Sqs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SqsImpl[R1] = new SqsImpl(api, newAspect, r)
    def getQueueAttributes(
        request: zio.aws.sqs.model.GetQueueAttributesRequest
    ): IO[AwsError, zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        GetQueueAttributesRequest,
        GetQueueAttributesResponse
      ]("getQueueAttributes", api.getQueueAttributes)(request.buildAwsValue())
        .map(zio.aws.sqs.model.GetQueueAttributesResponse.wrap)
        .provideEnvironment(r)
    def sendMessage(
        request: zio.aws.sqs.model.SendMessageRequest
    ): IO[AwsError, zio.aws.sqs.model.SendMessageResponse.ReadOnly] =
      asyncRequestResponse[SendMessageRequest, SendMessageResponse](
        "sendMessage",
        api.sendMessage
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.SendMessageResponse.wrap)
        .provideEnvironment(r)
    def listQueues(
        request: zio.aws.sqs.model.ListQueuesRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      ListQueuesRequest,
      ListQueuesResponse,
      java.lang.String
    ](
      "listQueues",
      api.listQueues,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queueUrls().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listQueuesPaginated(
        request: zio.aws.sqs.model.ListQueuesRequest
    ): IO[AwsError, zio.aws.sqs.model.ListQueuesResponse.ReadOnly] =
      asyncRequestResponse[ListQueuesRequest, ListQueuesResponse](
        "listQueues",
        api.listQueues
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.ListQueuesResponse.wrap)
        .provideEnvironment(r)
    def untagQueue(
        request: zio.aws.sqs.model.UntagQueueRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagQueueRequest, UntagQueueResponse](
        "untagQueue",
        api.untagQueue
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def tagQueue(
        request: zio.aws.sqs.model.TagQueueRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagQueueRequest, TagQueueResponse](
        "tagQueue",
        api.tagQueue
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteMessage(
        request: zio.aws.sqs.model.DeleteMessageRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteMessageRequest, DeleteMessageResponse](
        "deleteMessage",
        api.deleteMessage
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteMessageBatch(
        request: zio.aws.sqs.model.DeleteMessageBatchRequest
    ): IO[AwsError, zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteMessageBatchRequest,
        DeleteMessageBatchResponse
      ]("deleteMessageBatch", api.deleteMessageBatch)(request.buildAwsValue())
        .map(zio.aws.sqs.model.DeleteMessageBatchResponse.wrap)
        .provideEnvironment(r)
    def purgeQueue(
        request: zio.aws.sqs.model.PurgeQueueRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PurgeQueueRequest, PurgeQueueResponse](
        "purgeQueue",
        api.purgeQueue
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def addPermission(
        request: zio.aws.sqs.model.AddPermissionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AddPermissionRequest, AddPermissionResponse](
        "addPermission",
        api.addPermission
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listQueueTags(
        request: zio.aws.sqs.model.ListQueueTagsRequest
    ): IO[AwsError, zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly] =
      asyncRequestResponse[ListQueueTagsRequest, ListQueueTagsResponse](
        "listQueueTags",
        api.listQueueTags
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.ListQueueTagsResponse.wrap)
        .provideEnvironment(r)
    def createQueue(
        request: zio.aws.sqs.model.CreateQueueRequest
    ): IO[AwsError, zio.aws.sqs.model.CreateQueueResponse.ReadOnly] =
      asyncRequestResponse[CreateQueueRequest, CreateQueueResponse](
        "createQueue",
        api.createQueue
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.CreateQueueResponse.wrap)
        .provideEnvironment(r)
    def listDeadLetterSourceQueues(
        request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      ListDeadLetterSourceQueuesRequest,
      ListDeadLetterSourceQueuesResponse,
      java.lang.String
    ](
      "listDeadLetterSourceQueues",
      api.listDeadLetterSourceQueues,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queueUrls().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listDeadLetterSourceQueuesPaginated(
        request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListDeadLetterSourceQueuesRequest,
      ListDeadLetterSourceQueuesResponse
    ]("listDeadLetterSourceQueues", api.listDeadLetterSourceQueues)(
      request.buildAwsValue()
    ).map(zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.wrap)
      .provideEnvironment(r)
    def getQueueUrl(
        request: zio.aws.sqs.model.GetQueueUrlRequest
    ): IO[AwsError, zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly] =
      asyncRequestResponse[GetQueueUrlRequest, GetQueueUrlResponse](
        "getQueueUrl",
        api.getQueueUrl
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.GetQueueUrlResponse.wrap)
        .provideEnvironment(r)
    def removePermission(
        request: zio.aws.sqs.model.RemovePermissionRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[RemovePermissionRequest, RemovePermissionResponse](
        "removePermission",
        api.removePermission
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def receiveMessage(
        request: zio.aws.sqs.model.ReceiveMessageRequest
    ): IO[AwsError, zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly] =
      asyncRequestResponse[ReceiveMessageRequest, ReceiveMessageResponse](
        "receiveMessage",
        api.receiveMessage
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.ReceiveMessageResponse.wrap)
        .provideEnvironment(r)
    def setQueueAttributes(
        request: zio.aws.sqs.model.SetQueueAttributesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      SetQueueAttributesRequest,
      SetQueueAttributesResponse
    ]("setQueueAttributes", api.setQueueAttributes)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteQueue(
        request: zio.aws.sqs.model.DeleteQueueRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteQueueRequest, DeleteQueueResponse](
        "deleteQueue",
        api.deleteQueue
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def sendMessageBatch(
        request: zio.aws.sqs.model.SendMessageBatchRequest
    ): IO[AwsError, zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly] =
      asyncRequestResponse[SendMessageBatchRequest, SendMessageBatchResponse](
        "sendMessageBatch",
        api.sendMessageBatch
      )(request.buildAwsValue())
        .map(zio.aws.sqs.model.SendMessageBatchResponse.wrap)
        .provideEnvironment(r)
    def changeMessageVisibilityBatch(
        request: zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest
    ): IO[
      AwsError,
      zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.ReadOnly
    ] = asyncRequestResponse[
      ChangeMessageVisibilityBatchRequest,
      ChangeMessageVisibilityBatchResponse
    ]("changeMessageVisibilityBatch", api.changeMessageVisibilityBatch)(
      request.buildAwsValue()
    ).map(zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.wrap)
      .provideEnvironment(r)
    def changeMessageVisibility(
        request: zio.aws.sqs.model.ChangeMessageVisibilityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ChangeMessageVisibilityRequest,
      ChangeMessageVisibilityResponse
    ]("changeMessageVisibility", api.changeMessageVisibility)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def getQueueAttributes(
      request: zio.aws.sqs.model.GetQueueAttributesRequest
  ): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueueAttributes(request))
  def sendMessage(request: zio.aws.sqs.model.SendMessageRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.SendMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendMessage(request))
  def listQueues(
      request: zio.aws.sqs.model.ListQueuesRequest
  ): ZStream[zio.aws.sqs.Sqs, AwsError, String] =
    ZStream.serviceWithStream(_.listQueues(request))
  def listQueuesPaginated(request: zio.aws.sqs.model.ListQueuesRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.ListQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueuesPaginated(request))
  def untagQueue(
      request: zio.aws.sqs.model.UntagQueueRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagQueue(request))
  def tagQueue(
      request: zio.aws.sqs.model.TagQueueRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagQueue(request))
  def deleteMessage(
      request: zio.aws.sqs.model.DeleteMessageRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMessage(request))
  def deleteMessageBatch(
      request: zio.aws.sqs.model.DeleteMessageBatchRequest
  ): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMessageBatch(request))
  def purgeQueue(
      request: zio.aws.sqs.model.PurgeQueueRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.purgeQueue(request))
  def addPermission(
      request: zio.aws.sqs.model.AddPermissionRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addPermission(request))
  def listQueueTags(request: zio.aws.sqs.model.ListQueueTagsRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueueTags(request))
  def createQueue(request: zio.aws.sqs.model.CreateQueueRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.CreateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueue(request))
  def listDeadLetterSourceQueues(
      request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
  ): ZStream[zio.aws.sqs.Sqs, AwsError, String] =
    ZStream.serviceWithStream(_.listDeadLetterSourceQueues(request))
  def listDeadLetterSourceQueuesPaginated(
      request: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listDeadLetterSourceQueuesPaginated(request))
  def getQueueUrl(request: zio.aws.sqs.model.GetQueueUrlRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueueUrl(request))
  def removePermission(
      request: zio.aws.sqs.model.RemovePermissionRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removePermission(request))
  def receiveMessage(request: zio.aws.sqs.model.ReceiveMessageRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.receiveMessage(request))
  def setQueueAttributes(
      request: zio.aws.sqs.model.SetQueueAttributesRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setQueueAttributes(request))
  def deleteQueue(
      request: zio.aws.sqs.model.DeleteQueueRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteQueue(request))
  def sendMessageBatch(request: zio.aws.sqs.model.SendMessageBatchRequest): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendMessageBatch(request))
  def changeMessageVisibilityBatch(
      request: zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest
  ): ZIO[
    zio.aws.sqs.Sqs,
    AwsError,
    zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.changeMessageVisibilityBatch(request))
  def changeMessageVisibility(
      request: zio.aws.sqs.model.ChangeMessageVisibilityRequest
  ): ZIO[zio.aws.sqs.Sqs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.changeMessageVisibility(request))
}
