package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddPermissionRequest(
    queueUrl: String,
    label: String,
    awsAccountIds: Iterable[String],
    actions: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.AddPermissionRequest = {
    import AddPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.AddPermissionRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .label(label: java.lang.String)
      .awsAccountIds(awsAccountIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .actions(actions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.AddPermissionRequest.ReadOnly =
    zio.aws.sqs.model.AddPermissionRequest.wrap(buildAwsValue())
}
object AddPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.AddPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.AddPermissionRequest = zio.aws.sqs.model
      .AddPermissionRequest(queueUrl, label, awsAccountIds, actions)
    def queueUrl: String
    def label: String
    def awsAccountIds: List[String]
    def actions: List[String]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getLabel: ZIO[Any, Nothing, String] = ZIO.succeed(label)
    def getAwsAccountIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(awsAccountIds)
    def getActions: ZIO[Any, Nothing, List[String]] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.AddPermissionRequest
  ) extends zio.aws.sqs.model.AddPermissionRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val label: String = impl.label(): String
    override val awsAccountIds: List[String] = impl
      .awsAccountIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val actions: List[String] = impl
      .actions()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.AddPermissionRequest
  ): zio.aws.sqs.model.AddPermissionRequest.ReadOnly = new Wrapper(impl)
}
