package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchResultErrorEntry(
    id: String,
    senderFault: Boolean,
    code: String,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry = {
    import BatchResultErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry
      .builder()
      .id(id: java.lang.String)
      .senderFault(senderFault: java.lang.Boolean)
      .code(code: java.lang.String)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly =
    zio.aws.sqs.model.BatchResultErrorEntry.wrap(buildAwsValue())
}
object BatchResultErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.BatchResultErrorEntry = zio.aws.sqs.model
      .BatchResultErrorEntry(id, senderFault, code, message.map(value => value))
    def id: String
    def senderFault: Boolean
    def code: String
    def message: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getSenderFault: ZIO[Any, Nothing, Boolean] = ZIO.succeed(senderFault)
    def getCode: ZIO[Any, Nothing, String] = ZIO.succeed(code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry
  ) extends zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val senderFault: Boolean = impl.senderFault(): Boolean
    override val code: String = impl.code(): String
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry
  ): zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly = new Wrapper(impl)
}
