package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ChangeMessageVisibilityBatchRequest(
    queueUrl: String,
    entries: Iterable[
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest = {
    import ChangeMessageVisibilityBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest.ReadOnly =
    zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest.wrap(buildAwsValue())
}
object ChangeMessageVisibilityBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest =
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest(
        queueUrl,
        entries.map { item =>
          item.asEditable
        }
      )
    def queueUrl: String
    def entries: List[
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly
    ]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest
  ) extends zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val entries: List[
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest
  ): zio.aws.sqs.model.ChangeMessageVisibilityBatchRequest.ReadOnly =
    new Wrapper(impl)
}
