package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ChangeMessageVisibilityBatchRequestEntry(
    id: String,
    receiptHandle: String,
    visibilityTimeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = {
    import ChangeMessageVisibilityBatchRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry
      .builder()
      .id(id: java.lang.String)
      .receiptHandle(receiptHandle: java.lang.String)
      .optionallyWith(visibilityTimeout.map(value => value: java.lang.Integer))(
        _.visibilityTimeout
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly =
    zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry
      .wrap(buildAwsValue())
}
object ChangeMessageVisibilityBatchRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry =
      zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry(
        id,
        receiptHandle,
        visibilityTimeout.map(value => value)
      )
    def id: String
    def receiptHandle: String
    def visibilityTimeout: Optional[Integer]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getReceiptHandle: ZIO[Any, Nothing, String] = ZIO.succeed(receiptHandle)
    def getVisibilityTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("visibilityTimeout", visibilityTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry
  ) extends zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val receiptHandle: String = impl.receiptHandle(): String
    override val visibilityTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.visibilityTimeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry
  ): zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry.ReadOnly =
    new Wrapper(impl)
}
