package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sqs.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ChangeMessageVisibilityRequest(
    queueUrl: String,
    receiptHandle: String,
    visibilityTimeout: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest = {
    import ChangeMessageVisibilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .receiptHandle(receiptHandle: java.lang.String)
      .visibilityTimeout(visibilityTimeout: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ChangeMessageVisibilityRequest.ReadOnly =
    zio.aws.sqs.model.ChangeMessageVisibilityRequest.wrap(buildAwsValue())
}
object ChangeMessageVisibilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ChangeMessageVisibilityRequest =
      zio.aws.sqs.model.ChangeMessageVisibilityRequest(
        queueUrl,
        receiptHandle,
        visibilityTimeout
      )
    def queueUrl: String
    def receiptHandle: String
    def visibilityTimeout: Integer
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getReceiptHandle: ZIO[Any, Nothing, String] = ZIO.succeed(receiptHandle)
    def getVisibilityTimeout: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(visibilityTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest
  ) extends zio.aws.sqs.model.ChangeMessageVisibilityRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val receiptHandle: String = impl.receiptHandle(): String
    override val visibilityTimeout: Integer = impl.visibilityTimeout(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest
  ): zio.aws.sqs.model.ChangeMessageVisibilityRequest.ReadOnly = new Wrapper(
    impl
  )
}
