package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMessageBatchRequest(
    queueUrl: String,
    entries: Iterable[zio.aws.sqs.model.DeleteMessageBatchRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest = {
    import DeleteMessageBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.DeleteMessageBatchRequest.ReadOnly =
    zio.aws.sqs.model.DeleteMessageBatchRequest.wrap(buildAwsValue())
}
object DeleteMessageBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.DeleteMessageBatchRequest =
      zio.aws.sqs.model.DeleteMessageBatchRequest(
        queueUrl,
        entries.map { item =>
          item.asEditable
        }
      )
    def queueUrl: String
    def entries: List[zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest
  ) extends zio.aws.sqs.model.DeleteMessageBatchRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val entries
        : List[zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.sqs.model.DeleteMessageBatchRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest
  ): zio.aws.sqs.model.DeleteMessageBatchRequest.ReadOnly = new Wrapper(impl)
}
