package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteQueueRequest(queueUrl: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.DeleteQueueRequest = {
    import DeleteQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.DeleteQueueRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.DeleteQueueRequest.ReadOnly =
    zio.aws.sqs.model.DeleteQueueRequest.wrap(buildAwsValue())
}
object DeleteQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.DeleteQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.DeleteQueueRequest =
      zio.aws.sqs.model.DeleteQueueRequest(queueUrl)
    def queueUrl: String
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.DeleteQueueRequest
  ) extends zio.aws.sqs.model.DeleteQueueRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.DeleteQueueRequest
  ): zio.aws.sqs.model.DeleteQueueRequest.ReadOnly = new Wrapper(impl)
}
