package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueueUrlRequest(
    queueName: String,
    queueOwnerAWSAccountId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest = {
    import GetQueueUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest
      .builder()
      .queueName(queueName: java.lang.String)
      .optionallyWith(
        queueOwnerAWSAccountId.map(value => value: java.lang.String)
      )(_.queueOwnerAWSAccountId)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.GetQueueUrlRequest.ReadOnly =
    zio.aws.sqs.model.GetQueueUrlRequest.wrap(buildAwsValue())
}
object GetQueueUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.GetQueueUrlRequest = zio.aws.sqs.model
      .GetQueueUrlRequest(queueName, queueOwnerAWSAccountId.map(value => value))
    def queueName: String
    def queueOwnerAWSAccountId: Optional[String]
    def getQueueName: ZIO[Any, Nothing, String] = ZIO.succeed(queueName)
    def getQueueOwnerAWSAccountId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("queueOwnerAWSAccountId", queueOwnerAWSAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest
  ) extends zio.aws.sqs.model.GetQueueUrlRequest.ReadOnly {
    override val queueName: String = impl.queueName(): String
    override val queueOwnerAWSAccountId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueOwnerAWSAccountId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest
  ): zio.aws.sqs.model.GetQueueUrlRequest.ReadOnly = new Wrapper(impl)
}
