package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueueUrlResponse(
    queueUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse = {
    import GetQueueUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse
      .builder()
      .optionallyWith(queueUrl.map(value => value: java.lang.String))(
        _.queueUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly =
    zio.aws.sqs.model.GetQueueUrlResponse.wrap(buildAwsValue())
}
object GetQueueUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.GetQueueUrlResponse =
      zio.aws.sqs.model.GetQueueUrlResponse(queueUrl.map(value => value))
    def queueUrl: Optional[String]
    def getQueueUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("queueUrl", queueUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse
  ) extends zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly {
    override val queueUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.queueUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse
  ): zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly = new Wrapper(impl)
}
