package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListQueuesResponse(
    queueUrls: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListQueuesResponse = {
    import ListQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListQueuesResponse
      .builder()
      .optionallyWith(
        queueUrls.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.queueUrls)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ListQueuesResponse.ReadOnly =
    zio.aws.sqs.model.ListQueuesResponse.wrap(buildAwsValue())
}
object ListQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListQueuesResponse =
      zio.aws.sqs.model.ListQueuesResponse(
        queueUrls.map(value => value),
        nextToken.map(value => value)
      )
    def queueUrls: Optional[List[String]]
    def nextToken: Optional[Token]
    def getQueueUrls: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("queueUrls", queueUrls)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListQueuesResponse
  ) extends zio.aws.sqs.model.ListQueuesResponse.ReadOnly {
    override val queueUrls: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.queueUrls())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sqs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListQueuesResponse
  ): zio.aws.sqs.model.ListQueuesResponse.ReadOnly = new Wrapper(impl)
}
