package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Message(
    messageId: Optional[String] = Optional.Absent,
    receiptHandle: Optional[String] = Optional.Absent,
    md5OfBody: Optional[String] = Optional.Absent,
    body: Optional[String] = Optional.Absent,
    attributes: Optional[
      Map[zio.aws.sqs.model.MessageSystemAttributeName, String]
    ] = Optional.Absent,
    md5OfMessageAttributes: Optional[String] = Optional.Absent,
    messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sqs.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.Message
      .builder()
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .optionallyWith(receiptHandle.map(value => value: java.lang.String))(
        _.receiptHandle
      )
      .optionallyWith(md5OfBody.map(value => value: java.lang.String))(
        _.md5OfBody
      )
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributesWithStrings)
      .optionallyWith(
        md5OfMessageAttributes.map(value => value: java.lang.String)
      )(_.md5OfMessageAttributes)
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.Message.ReadOnly =
    zio.aws.sqs.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sqs.model.Message] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.Message = zio.aws.sqs.model.Message(
      messageId.map(value => value),
      receiptHandle.map(value => value),
      md5OfBody.map(value => value),
      body.map(value => value),
      attributes.map(value => value),
      md5OfMessageAttributes.map(value => value),
      messageAttributes.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    )
    def messageId: Optional[String]
    def receiptHandle: Optional[String]
    def md5OfBody: Optional[String]
    def body: Optional[String]
    def attributes
        : Optional[Map[zio.aws.sqs.model.MessageSystemAttributeName, String]]
    def md5OfMessageAttributes: Optional[String]
    def messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue.ReadOnly]
    ]
    def getMessageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getReceiptHandle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("receiptHandle", receiptHandle)
    def getMd5OfBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("md5OfBody", md5OfBody)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getAttributes: ZIO[Any, AwsError, Map[
      zio.aws.sqs.model.MessageSystemAttributeName,
      String
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getMd5OfMessageAttributes: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("md5OfMessageAttributes", md5OfMessageAttributes)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      String,
      zio.aws.sqs.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.Message
  ) extends zio.aws.sqs.model.Message.ReadOnly {
    override val messageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: String)
    override val receiptHandle: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.receiptHandle())
      .map(value => value: String)
    override val md5OfBody: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.md5OfBody())
      .map(value => value: String)
    override val body: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: String)
    override val attributes
        : Optional[Map[zio.aws.sqs.model.MessageSystemAttributeName, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sqs.model.MessageSystemAttributeName
                .wrap(key) -> (value: String)
            })
            .toMap
        )
    override val md5OfMessageAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.md5OfMessageAttributes())
        .map(value => value: String)
    override val messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.sqs.model.MessageAttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.Message
  ): zio.aws.sqs.model.Message.ReadOnly = new Wrapper(impl)
}
