package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReceiveMessageResponse(
    messages: Optional[Iterable[zio.aws.sqs.model.Message]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse = {
    import ReceiveMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse
      .builder()
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly =
    zio.aws.sqs.model.ReceiveMessageResponse.wrap(buildAwsValue())
}
object ReceiveMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ReceiveMessageResponse =
      zio.aws.sqs.model.ReceiveMessageResponse(
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def messages: Optional[List[zio.aws.sqs.model.Message.ReadOnly]]
    def getMessages
        : ZIO[Any, AwsError, List[zio.aws.sqs.model.Message.ReadOnly]] =
      AwsError.unwrapOptionField("messages", messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse
  ) extends zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly {
    override val messages: Optional[List[zio.aws.sqs.model.Message.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sqs.model.Message.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse
  ): zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly = new Wrapper(impl)
}
