package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemovePermissionRequest(queueUrl: String, label: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.RemovePermissionRequest = {
    import RemovePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.RemovePermissionRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .label(label: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.RemovePermissionRequest.ReadOnly =
    zio.aws.sqs.model.RemovePermissionRequest.wrap(buildAwsValue())
}
object RemovePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.RemovePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.RemovePermissionRequest =
      zio.aws.sqs.model.RemovePermissionRequest(queueUrl, label)
    def queueUrl: String
    def label: String
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getLabel: ZIO[Any, Nothing, String] = ZIO.succeed(label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.RemovePermissionRequest
  ) extends zio.aws.sqs.model.RemovePermissionRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val label: String = impl.label(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.RemovePermissionRequest
  ): zio.aws.sqs.model.RemovePermissionRequest.ReadOnly = new Wrapper(impl)
}
