package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class SendMessageBatchRequestEntry(
    id: String,
    messageBody: String,
    delaySeconds: Optional[Integer] = Optional.Absent,
    messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue]
    ] = Optional.Absent,
    messageSystemAttributes: Optional[Map[
      zio.aws.sqs.model.MessageSystemAttributeNameForSends,
      zio.aws.sqs.model.MessageSystemAttributeValue
    ]] = Optional.Absent,
    messageDeduplicationId: Optional[String] = Optional.Absent,
    messageGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry = {
    import SendMessageBatchRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry
      .builder()
      .id(id: java.lang.String)
      .messageBody(messageBody: java.lang.String)
      .optionallyWith(delaySeconds.map(value => value: java.lang.Integer))(
        _.delaySeconds
      )
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .optionallyWith(
        messageSystemAttributes.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.messageSystemAttributesWithStrings)
      .optionallyWith(
        messageDeduplicationId.map(value => value: java.lang.String)
      )(_.messageDeduplicationId)
      .optionallyWith(messageGroupId.map(value => value: java.lang.String))(
        _.messageGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly =
    zio.aws.sqs.model.SendMessageBatchRequestEntry.wrap(buildAwsValue())
}
object SendMessageBatchRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SendMessageBatchRequestEntry =
      zio.aws.sqs.model.SendMessageBatchRequestEntry(
        id,
        messageBody,
        delaySeconds.map(value => value),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        messageSystemAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        messageDeduplicationId.map(value => value),
        messageGroupId.map(value => value)
      )
    def id: String
    def messageBody: String
    def delaySeconds: Optional[Integer]
    def messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue.ReadOnly]
    ]
    def messageSystemAttributes: Optional[Map[
      zio.aws.sqs.model.MessageSystemAttributeNameForSends,
      zio.aws.sqs.model.MessageSystemAttributeValue.ReadOnly
    ]]
    def messageDeduplicationId: Optional[String]
    def messageGroupId: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getMessageBody: ZIO[Any, Nothing, String] = ZIO.succeed(messageBody)
    def getDelaySeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("delaySeconds", delaySeconds)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      String,
      zio.aws.sqs.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
    def getMessageSystemAttributes: ZIO[Any, AwsError, Map[
      zio.aws.sqs.model.MessageSystemAttributeNameForSends,
      zio.aws.sqs.model.MessageSystemAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "messageSystemAttributes",
      messageSystemAttributes
    )
    def getMessageDeduplicationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("messageDeduplicationId", messageDeduplicationId)
    def getMessageGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageGroupId", messageGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry
  ) extends zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val messageBody: String = impl.messageBody(): String
    override val delaySeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.delaySeconds())
      .map(value => value: Integer)
    override val messageAttributes: Optional[
      Map[String, zio.aws.sqs.model.MessageAttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.sqs.model.MessageAttributeValue.wrap(value)
          })
          .toMap
      )
    override val messageSystemAttributes: Optional[Map[
      zio.aws.sqs.model.MessageSystemAttributeNameForSends,
      zio.aws.sqs.model.MessageSystemAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.messageSystemAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sqs.model.MessageSystemAttributeNameForSends.wrap(
              key
            ) -> zio.aws.sqs.model.MessageSystemAttributeValue.wrap(value)
          })
          .toMap
      )
    override val messageDeduplicationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageDeduplicationId())
        .map(value => value: String)
    override val messageGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageGroupId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry
  ): zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly = new Wrapper(impl)
}
