package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetQueueAttributesRequest(
    queueUrl: String,
    attributes: Map[zio.aws.sqs.model.QueueAttributeName, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest = {
    import SetQueueAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .attributesWithStrings(
        attributes
          .map({ case (key, value) =>
            key.unwrap.toString -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SetQueueAttributesRequest.ReadOnly =
    zio.aws.sqs.model.SetQueueAttributesRequest.wrap(buildAwsValue())
}
object SetQueueAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SetQueueAttributesRequest =
      zio.aws.sqs.model.SetQueueAttributesRequest(queueUrl, attributes)
    def queueUrl: String
    def attributes: Map[zio.aws.sqs.model.QueueAttributeName, String]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getAttributes
        : ZIO[Any, Nothing, Map[zio.aws.sqs.model.QueueAttributeName, String]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest
  ) extends zio.aws.sqs.model.SetQueueAttributesRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val attributes: Map[zio.aws.sqs.model.QueueAttributeName, String] =
      impl
        .attributes()
        .asScala
        .map({ case (key, value) =>
          zio.aws.sqs.model.QueueAttributeName.wrap(key) -> (value: String)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest
  ): zio.aws.sqs.model.SetQueueAttributesRequest.ReadOnly = new Wrapper(impl)
}
