package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sqs.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class TagQueueRequest(
    queueUrl: String,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.TagQueueRequest = {
    import TagQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.TagQueueRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.TagQueueRequest.ReadOnly =
    zio.aws.sqs.model.TagQueueRequest.wrap(buildAwsValue())
}
object TagQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.TagQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.TagQueueRequest =
      zio.aws.sqs.model.TagQueueRequest(queueUrl, tags)
    def queueUrl: String
    def tags: Map[TagKey, TagValue]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.TagQueueRequest
  ) extends zio.aws.sqs.model.TagQueueRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.sqs.model.primitives.TagKey(key) -> zio.aws.sqs.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.TagQueueRequest
  ): zio.aws.sqs.model.TagQueueRequest.ReadOnly = new Wrapper(impl)
}
