package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sqs.model.primitives.TagKey
import scala.jdk.CollectionConverters.*
final case class UntagQueueRequest(
    queueUrl: String,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.UntagQueueRequest = {
    import UntagQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.UntagQueueRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.UntagQueueRequest.ReadOnly =
    zio.aws.sqs.model.UntagQueueRequest.wrap(buildAwsValue())
}
object UntagQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.UntagQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.UntagQueueRequest =
      zio.aws.sqs.model.UntagQueueRequest(queueUrl, tagKeys)
    def queueUrl: String
    def tagKeys: List[TagKey]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.UntagQueueRequest
  ) extends zio.aws.sqs.model.UntagQueueRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.sqs.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.UntagQueueRequest
  ): zio.aws.sqs.model.UntagQueueRequest.ReadOnly = new Wrapper(impl)
}
