package zio.aws.sqs
import zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.sqs.model.{
  PurgeQueueRequest,
  ListQueuesRequest,
  DeleteQueueRequest,
  TagQueueRequest,
  DeleteMessageBatchRequest,
  ReceiveMessageRequest,
  CreateQueueRequest,
  ChangeMessageVisibilityBatchRequest,
  SendMessageBatchRequest,
  SendMessageRequest,
  GetQueueAttributesRequest,
  SetQueueAttributesRequest,
  UntagQueueRequest,
  AddPermissionRequest,
  RemovePermissionRequest,
  ChangeMessageVisibilityRequest,
  ListDeadLetterSourceQueuesRequest,
  DeleteMessageRequest,
  ListQueueTagsRequest,
  GetQueueUrlRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.sqs.SqsAsyncClient
import zio.stream.ZStream
object SqsMock extends Mock[Sqs] {
  object GetQueueAttributes
      extends Effect[
        GetQueueAttributesRequest,
        AwsError,
        zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly
      ]
  object SendMessage
      extends Effect[
        SendMessageRequest,
        AwsError,
        zio.aws.sqs.model.SendMessageResponse.ReadOnly
      ]
  object ListQueues extends Stream[ListQueuesRequest, AwsError, String]
  object ListQueuesPaginated
      extends Effect[
        ListQueuesRequest,
        AwsError,
        zio.aws.sqs.model.ListQueuesResponse.ReadOnly
      ]
  object UntagQueue extends Effect[UntagQueueRequest, AwsError, Unit]
  object TagQueue extends Effect[TagQueueRequest, AwsError, Unit]
  object DeleteMessage extends Effect[DeleteMessageRequest, AwsError, Unit]
  object DeleteMessageBatch
      extends Effect[
        DeleteMessageBatchRequest,
        AwsError,
        zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly
      ]
  object PurgeQueue extends Effect[PurgeQueueRequest, AwsError, Unit]
  object AddPermission extends Effect[AddPermissionRequest, AwsError, Unit]
  object ListQueueTags
      extends Effect[
        ListQueueTagsRequest,
        AwsError,
        zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly
      ]
  object CreateQueue
      extends Effect[
        CreateQueueRequest,
        AwsError,
        zio.aws.sqs.model.CreateQueueResponse.ReadOnly
      ]
  object ListDeadLetterSourceQueues
      extends Stream[ListDeadLetterSourceQueuesRequest, AwsError, String]
  object ListDeadLetterSourceQueuesPaginated
      extends Effect[ListDeadLetterSourceQueuesRequest, AwsError, ReadOnly]
  object GetQueueUrl
      extends Effect[
        GetQueueUrlRequest,
        AwsError,
        zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly
      ]
  object RemovePermission
      extends Effect[RemovePermissionRequest, AwsError, Unit]
  object ReceiveMessage
      extends Effect[
        ReceiveMessageRequest,
        AwsError,
        zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly
      ]
  object SetQueueAttributes
      extends Effect[SetQueueAttributesRequest, AwsError, Unit]
  object DeleteQueue extends Effect[DeleteQueueRequest, AwsError, Unit]
  object SendMessageBatch
      extends Effect[
        SendMessageBatchRequest,
        AwsError,
        zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly
      ]
  object ChangeMessageVisibilityBatch
      extends Effect[
        ChangeMessageVisibilityBatchRequest,
        AwsError,
        zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.ReadOnly
      ]
  object ChangeMessageVisibility
      extends Effect[ChangeMessageVisibilityRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Sqs] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sqs] { rts =>
        zio.ZIO.succeed {
          new Sqs {
            val api: SqsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sqs = this
            def getQueueAttributes(request: GetQueueAttributesRequest): IO[
              AwsError,
              zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly
            ] = proxy(GetQueueAttributes, request)
            def sendMessage(
                request: SendMessageRequest
            ): IO[AwsError, zio.aws.sqs.model.SendMessageResponse.ReadOnly] =
              proxy(SendMessage, request)
            def listQueues(
                request: ListQueuesRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListQueues, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listQueuesPaginated(
                request: ListQueuesRequest
            ): IO[AwsError, zio.aws.sqs.model.ListQueuesResponse.ReadOnly] =
              proxy(ListQueuesPaginated, request)
            def untagQueue(request: UntagQueueRequest): IO[AwsError, Unit] =
              proxy(UntagQueue, request)
            def tagQueue(request: TagQueueRequest): IO[AwsError, Unit] =
              proxy(TagQueue, request)
            def deleteMessage(
                request: DeleteMessageRequest
            ): IO[AwsError, Unit] = proxy(DeleteMessage, request)
            def deleteMessageBatch(request: DeleteMessageBatchRequest): IO[
              AwsError,
              zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly
            ] = proxy(DeleteMessageBatch, request)
            def purgeQueue(request: PurgeQueueRequest): IO[AwsError, Unit] =
              proxy(PurgeQueue, request)
            def addPermission(
                request: AddPermissionRequest
            ): IO[AwsError, Unit] = proxy(AddPermission, request)
            def listQueueTags(
                request: ListQueueTagsRequest
            ): IO[AwsError, zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly] =
              proxy(ListQueueTags, request)
            def createQueue(
                request: CreateQueueRequest
            ): IO[AwsError, zio.aws.sqs.model.CreateQueueResponse.ReadOnly] =
              proxy(CreateQueue, request)
            def listDeadLetterSourceQueues(
                request: ListDeadLetterSourceQueuesRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDeadLetterSourceQueues, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDeadLetterSourceQueuesPaginated(
                request: ListDeadLetterSourceQueuesRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListDeadLetterSourceQueuesPaginated, request)
            def getQueueUrl(
                request: GetQueueUrlRequest
            ): IO[AwsError, zio.aws.sqs.model.GetQueueUrlResponse.ReadOnly] =
              proxy(GetQueueUrl, request)
            def removePermission(
                request: RemovePermissionRequest
            ): IO[AwsError, Unit] = proxy(RemovePermission, request)
            def receiveMessage(
                request: ReceiveMessageRequest
            ): IO[AwsError, zio.aws.sqs.model.ReceiveMessageResponse.ReadOnly] =
              proxy(ReceiveMessage, request)
            def setQueueAttributes(
                request: SetQueueAttributesRequest
            ): IO[AwsError, Unit] = proxy(SetQueueAttributes, request)
            def deleteQueue(request: DeleteQueueRequest): IO[AwsError, Unit] =
              proxy(DeleteQueue, request)
            def sendMessageBatch(request: SendMessageBatchRequest): IO[
              AwsError,
              zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly
            ] = proxy(SendMessageBatch, request)
            def changeMessageVisibilityBatch(
                request: ChangeMessageVisibilityBatchRequest
            ): IO[
              AwsError,
              zio.aws.sqs.model.ChangeMessageVisibilityBatchResponse.ReadOnly
            ] = proxy(ChangeMessageVisibilityBatch, request)
            def changeMessageVisibility(
                request: ChangeMessageVisibilityRequest
            ): IO[AwsError, Unit] = proxy(ChangeMessageVisibility, request)
          }
        }
      }
    }
  }
}
