package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class CreateQueueRequest(
    queueName: String,
    attributes: Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.CreateQueueRequest = {
    import CreateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.CreateQueueRequest
      .builder()
      .queueName(queueName: java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.CreateQueueRequest.ReadOnly =
    zio.aws.sqs.model.CreateQueueRequest.wrap(buildAwsValue())
}
object CreateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.CreateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.CreateQueueRequest =
      zio.aws.sqs.model.CreateQueueRequest(
        queueName,
        attributes.map(value => value),
        tags.map(value => value)
      )
    def queueName: String
    def attributes: Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getQueueName: ZIO[Any, Nothing, String] = ZIO.succeed(queueName)
    def getAttributes: ZIO[Any, AwsError, Map[
      zio.aws.sqs.model.QueueAttributeName,
      String
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.CreateQueueRequest
  ) extends zio.aws.sqs.model.CreateQueueRequest.ReadOnly {
    override val queueName: String = impl.queueName(): String
    override val attributes
        : Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sqs.model.QueueAttributeName.wrap(key) -> (value: String)
            })
            .toMap
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sqs.model.primitives
              .TagKey(key) -> zio.aws.sqs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.CreateQueueRequest
  ): zio.aws.sqs.model.CreateQueueRequest.ReadOnly = new Wrapper(impl)
}
