package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateQueueResponse(
    queueUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.CreateQueueResponse = {
    import CreateQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.CreateQueueResponse
      .builder()
      .optionallyWith(queueUrl.map(value => value: java.lang.String))(
        _.queueUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.CreateQueueResponse.ReadOnly =
    zio.aws.sqs.model.CreateQueueResponse.wrap(buildAwsValue())
}
object CreateQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.CreateQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.CreateQueueResponse =
      zio.aws.sqs.model.CreateQueueResponse(queueUrl.map(value => value))
    def queueUrl: Optional[String]
    def getQueueUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("queueUrl", queueUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.CreateQueueResponse
  ) extends zio.aws.sqs.model.CreateQueueResponse.ReadOnly {
    override val queueUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.queueUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.CreateQueueResponse
  ): zio.aws.sqs.model.CreateQueueResponse.ReadOnly = new Wrapper(impl)
}
