package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMessageBatchRequestEntry(
    id: String,
    receiptHandle: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry = {
    import DeleteMessageBatchRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry
      .builder()
      .id(id: java.lang.String)
      .receiptHandle(receiptHandle: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly =
    zio.aws.sqs.model.DeleteMessageBatchRequestEntry.wrap(buildAwsValue())
}
object DeleteMessageBatchRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.DeleteMessageBatchRequestEntry =
      zio.aws.sqs.model.DeleteMessageBatchRequestEntry(id, receiptHandle)
    def id: String
    def receiptHandle: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getReceiptHandle: ZIO[Any, Nothing, String] = ZIO.succeed(receiptHandle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry
  ) extends zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val receiptHandle: String = impl.receiptHandle(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry
  ): zio.aws.sqs.model.DeleteMessageBatchRequestEntry.ReadOnly = new Wrapper(
    impl
  )
}
