package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMessageBatchResponse(
    successful: Iterable[zio.aws.sqs.model.DeleteMessageBatchResultEntry],
    failed: Iterable[zio.aws.sqs.model.BatchResultErrorEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse = {
    import DeleteMessageBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse
      .builder()
      .successful(successful.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failed(failed.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly =
    zio.aws.sqs.model.DeleteMessageBatchResponse.wrap(buildAwsValue())
}
object DeleteMessageBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.DeleteMessageBatchResponse =
      zio.aws.sqs.model.DeleteMessageBatchResponse(
        successful.map { item =>
          item.asEditable
        },
        failed.map { item =>
          item.asEditable
        }
      )
    def successful
        : List[zio.aws.sqs.model.DeleteMessageBatchResultEntry.ReadOnly]
    def failed: List[zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly]
    def getSuccessful: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.DeleteMessageBatchResultEntry.ReadOnly
    ]] = ZIO.succeed(successful)
    def getFailed: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly
    ]] = ZIO.succeed(failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse
  ) extends zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly {
    override val successful
        : List[zio.aws.sqs.model.DeleteMessageBatchResultEntry.ReadOnly] = impl
      .successful()
      .asScala
      .map { item =>
        zio.aws.sqs.model.DeleteMessageBatchResultEntry.wrap(item)
      }
      .toList
    override val failed
        : List[zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly] = impl
      .failed()
      .asScala
      .map { item =>
        zio.aws.sqs.model.BatchResultErrorEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse
  ): zio.aws.sqs.model.DeleteMessageBatchResponse.ReadOnly = new Wrapper(impl)
}
