package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMessageRequest(queueUrl: String, receiptHandle: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.DeleteMessageRequest = {
    import DeleteMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.DeleteMessageRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .receiptHandle(receiptHandle: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.DeleteMessageRequest.ReadOnly =
    zio.aws.sqs.model.DeleteMessageRequest.wrap(buildAwsValue())
}
object DeleteMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.DeleteMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.DeleteMessageRequest =
      zio.aws.sqs.model.DeleteMessageRequest(queueUrl, receiptHandle)
    def queueUrl: String
    def receiptHandle: String
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getReceiptHandle: ZIO[Any, Nothing, String] = ZIO.succeed(receiptHandle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageRequest
  ) extends zio.aws.sqs.model.DeleteMessageRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val receiptHandle: String = impl.receiptHandle(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.DeleteMessageRequest
  ): zio.aws.sqs.model.DeleteMessageRequest.ReadOnly = new Wrapper(impl)
}
