package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueueAttributesRequest(
    queueUrl: String,
    attributeNames: Optional[Iterable[zio.aws.sqs.model.QueueAttributeName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest = {
    import GetQueueAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.GetQueueAttributesRequest.ReadOnly =
    zio.aws.sqs.model.GetQueueAttributesRequest.wrap(buildAwsValue())
}
object GetQueueAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.GetQueueAttributesRequest =
      zio.aws.sqs.model
        .GetQueueAttributesRequest(queueUrl, attributeNames.map(value => value))
    def queueUrl: String
    def attributeNames: Optional[List[zio.aws.sqs.model.QueueAttributeName]]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getAttributeNames
        : ZIO[Any, AwsError, List[zio.aws.sqs.model.QueueAttributeName]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest
  ) extends zio.aws.sqs.model.GetQueueAttributesRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val attributeNames
        : Optional[List[zio.aws.sqs.model.QueueAttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sqs.model.QueueAttributeName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest
  ): zio.aws.sqs.model.GetQueueAttributesRequest.ReadOnly = new Wrapper(impl)
}
