package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueueAttributesResponse(
    attributes: Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse = {
    import GetQueueAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly =
    zio.aws.sqs.model.GetQueueAttributesResponse.wrap(buildAwsValue())
}
object GetQueueAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.GetQueueAttributesResponse =
      zio.aws.sqs.model
        .GetQueueAttributesResponse(attributes.map(value => value))
    def attributes: Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]]
    def getAttributes: ZIO[Any, AwsError, Map[
      zio.aws.sqs.model.QueueAttributeName,
      String
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse
  ) extends zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly {
    override val attributes
        : Optional[Map[zio.aws.sqs.model.QueueAttributeName, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sqs.model.QueueAttributeName.wrap(key) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse
  ): zio.aws.sqs.model.GetQueueAttributesResponse.ReadOnly = new Wrapper(impl)
}
