package zio.aws.sqs.model
import zio.aws.sqs.model.primitives.{BoxedInteger, Token}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDeadLetterSourceQueuesRequest(
    queueUrl: String,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest = {
    import ListDeadLetterSourceQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest.ReadOnly =
    zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest.wrap(buildAwsValue())
}
object ListDeadLetterSourceQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest =
      zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest(
        queueUrl,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def queueUrl: String
    def nextToken: Optional[Token]
    def maxResults: Optional[BoxedInteger]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest
  ) extends zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sqs.model.primitives.Token(value))
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest
  ): zio.aws.sqs.model.ListDeadLetterSourceQueuesRequest.ReadOnly = new Wrapper(
    impl
  )
}
