package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListDeadLetterSourceQueuesResponse(
    queueUrls: Iterable[String],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse = {
    import ListDeadLetterSourceQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse
      .builder()
      .queueUrls(queueUrls.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.ReadOnly =
    zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.wrap(buildAwsValue())
}
object ListDeadLetterSourceQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse =
      zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse(
        queueUrls,
        nextToken.map(value => value)
      )
    def queueUrls: List[String]
    def nextToken: Optional[Token]
    def getQueueUrls: ZIO[Any, Nothing, List[String]] = ZIO.succeed(queueUrls)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse
  ) extends zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.ReadOnly {
    override val queueUrls: List[String] = impl
      .queueUrls()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sqs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse
  ): zio.aws.sqs.model.ListDeadLetterSourceQueuesResponse.ReadOnly =
    new Wrapper(impl)
}
