package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListQueueTagsRequest(queueUrl: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest = {
    import ListQueueTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ListQueueTagsRequest.ReadOnly =
    zio.aws.sqs.model.ListQueueTagsRequest.wrap(buildAwsValue())
}
object ListQueueTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListQueueTagsRequest =
      zio.aws.sqs.model.ListQueueTagsRequest(queueUrl)
    def queueUrl: String
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest
  ) extends zio.aws.sqs.model.ListQueueTagsRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest
  ): zio.aws.sqs.model.ListQueueTagsRequest.ReadOnly = new Wrapper(impl)
}
