package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class ListQueueTagsResponse(
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse = {
    import ListQueueTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly =
    zio.aws.sqs.model.ListQueueTagsResponse.wrap(buildAwsValue())
}
object ListQueueTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListQueueTagsResponse =
      zio.aws.sqs.model.ListQueueTagsResponse(tags.map(value => value))
    def tags: Optional[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse
  ) extends zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly {
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sqs.model.primitives
              .TagKey(key) -> zio.aws.sqs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse
  ): zio.aws.sqs.model.ListQueueTagsResponse.ReadOnly = new Wrapper(impl)
}
