package zio.aws.sqs.model
import zio.aws.sqs.model.primitives.{BoxedInteger, Token}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListQueuesRequest(
    queueNamePrefix: Optional[String] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ListQueuesRequest = {
    import ListQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ListQueuesRequest
      .builder()
      .optionallyWith(queueNamePrefix.map(value => value: java.lang.String))(
        _.queueNamePrefix
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ListQueuesRequest.ReadOnly =
    zio.aws.sqs.model.ListQueuesRequest.wrap(buildAwsValue())
}
object ListQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ListQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ListQueuesRequest =
      zio.aws.sqs.model.ListQueuesRequest(
        queueNamePrefix.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def queueNamePrefix: Optional[String]
    def nextToken: Optional[Token]
    def maxResults: Optional[BoxedInteger]
    def getQueueNamePrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("queueNamePrefix", queueNamePrefix)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ListQueuesRequest
  ) extends zio.aws.sqs.model.ListQueuesRequest.ReadOnly {
    override val queueNamePrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.queueNamePrefix())
      .map(value => value: String)
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sqs.model.primitives.Token(value))
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ListQueuesRequest
  ): zio.aws.sqs.model.ListQueuesRequest.ReadOnly = new Wrapper(impl)
}
