package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.Binary
import scala.jdk.CollectionConverters.*
final case class MessageAttributeValue(
    stringValue: Optional[String] = Optional.Absent,
    binaryValue: Optional[Binary] = Optional.Absent,
    stringListValues: Optional[Iterable[String]] = Optional.Absent,
    binaryListValues: Optional[Iterable[Binary]] = Optional.Absent,
    dataType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.MessageAttributeValue = {
    import MessageAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.MessageAttributeValue
      .builder()
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .optionallyWith(
        binaryValue.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.binaryValue)
      .optionallyWith(
        stringListValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringListValues)
      .optionallyWith(
        binaryListValues.map(value =>
          value.map { item =>
            software.amazon.awssdk.core.SdkBytes
              .fromByteArrayUnsafe(item.toArray[Byte])
          }.asJavaCollection
        )
      )(_.binaryListValues)
      .dataType(dataType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.MessageAttributeValue.ReadOnly =
    zio.aws.sqs.model.MessageAttributeValue.wrap(buildAwsValue())
}
object MessageAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.MessageAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.MessageAttributeValue =
      zio.aws.sqs.model.MessageAttributeValue(
        stringValue.map(value => value),
        binaryValue.map(value => value),
        stringListValues.map(value => value),
        binaryListValues.map(value => value),
        dataType
      )
    def stringValue: Optional[String]
    def binaryValue: Optional[Binary]
    def stringListValues: Optional[List[String]]
    def binaryListValues: Optional[List[Binary]]
    def dataType: String
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getBinaryValue: ZIO[Any, AwsError, Binary] =
      AwsError.unwrapOptionField("binaryValue", binaryValue)
    def getStringListValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringListValues", stringListValues)
    def getBinaryListValues: ZIO[Any, AwsError, List[Binary]] =
      AwsError.unwrapOptionField("binaryListValues", binaryListValues)
    def getDataType: ZIO[Any, Nothing, String] = ZIO.succeed(dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.MessageAttributeValue
  ) extends zio.aws.sqs.model.MessageAttributeValue.ReadOnly {
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
    override val binaryValue: Optional[Binary] = zio.aws.core.internal
      .optionalFromNullable(impl.binaryValue())
      .map(value =>
        zio.aws.sqs.model.primitives
          .Binary(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val stringListValues: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringListValues())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val binaryListValues: Optional[List[Binary]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binaryListValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sqs.model.primitives
              .Binary(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
          }.toList
        )
    override val dataType: String = impl.dataType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.MessageAttributeValue
  ): zio.aws.sqs.model.MessageAttributeValue.ReadOnly = new Wrapper(impl)
}
