package zio.aws.sqs.model
import scala.jdk.CollectionConverters.*
sealed trait MessageSystemAttributeName {
  def unwrap
      : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName
}
object MessageSystemAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName
  ): zio.aws.sqs.model.MessageSystemAttributeName = value match {
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SENDER_ID =>
      val r = SenderId
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SENT_TIMESTAMP =>
      val r = SentTimestamp
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.APPROXIMATE_RECEIVE_COUNT =>
      val r = ApproximateReceiveCount
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP =>
      val r = ApproximateFirstReceiveTimestamp
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SEQUENCE_NUMBER =>
      val r = SequenceNumber
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID =>
      val r = MessageDeduplicationId
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.MESSAGE_GROUP_ID =>
      val r = MessageGroupId
      r
    case software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.AWS_TRACE_HEADER =>
      val r = AWSTraceHeader
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object SenderId extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SENDER_ID
  }
  case object SentTimestamp
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SENT_TIMESTAMP
  }
  case object ApproximateReceiveCount
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.APPROXIMATE_RECEIVE_COUNT
  }
  case object ApproximateFirstReceiveTimestamp
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP
  }
  case object SequenceNumber
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.SEQUENCE_NUMBER
  }
  case object MessageDeduplicationId
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID
  }
  case object MessageGroupId
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.MESSAGE_GROUP_ID
  }
  case object AWSTraceHeader
      extends zio.aws.sqs.model.MessageSystemAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName =
      software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName.AWS_TRACE_HEADER
  }
}
