package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PurgeQueueRequest(queueUrl: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.PurgeQueueRequest = {
    import PurgeQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.PurgeQueueRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.PurgeQueueRequest.ReadOnly =
    zio.aws.sqs.model.PurgeQueueRequest.wrap(buildAwsValue())
}
object PurgeQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.PurgeQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.PurgeQueueRequest =
      zio.aws.sqs.model.PurgeQueueRequest(queueUrl)
    def queueUrl: String
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.PurgeQueueRequest
  ) extends zio.aws.sqs.model.PurgeQueueRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.PurgeQueueRequest
  ): zio.aws.sqs.model.PurgeQueueRequest.ReadOnly = new Wrapper(impl)
}
