package zio.aws.sqs.model
import scala.jdk.CollectionConverters.*
sealed trait QueueAttributeName {
  def unwrap: software.amazon.awssdk.services.sqs.model.QueueAttributeName
}
object QueueAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.sqs.model.QueueAttributeName
  ): zio.aws.sqs.model.QueueAttributeName = value match {
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.POLICY =>
      val r = Policy
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.VISIBILITY_TIMEOUT =>
      val r = VisibilityTimeout
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.MAXIMUM_MESSAGE_SIZE =>
      val r = MaximumMessageSize
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.MESSAGE_RETENTION_PERIOD =>
      val r = MessageRetentionPeriod
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES =>
      val r = ApproximateNumberOfMessages
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES_NOT_VISIBLE =>
      val r = ApproximateNumberOfMessagesNotVisible
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.CREATED_TIMESTAMP =>
      val r = CreatedTimestamp
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.LAST_MODIFIED_TIMESTAMP =>
      val r = LastModifiedTimestamp
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.QUEUE_ARN =>
      val r = QueueArn
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES_DELAYED =>
      val r = ApproximateNumberOfMessagesDelayed
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.DELAY_SECONDS =>
      val r = DelaySeconds
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS =>
      val r = ReceiveMessageWaitTimeSeconds
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.REDRIVE_POLICY =>
      val r = RedrivePolicy
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.FIFO_QUEUE =>
      val r = FifoQueue
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.CONTENT_BASED_DEDUPLICATION =>
      val r = ContentBasedDeduplication
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.KMS_MASTER_KEY_ID =>
      val r = KmsMasterKeyId
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS =>
      val r = KmsDataKeyReusePeriodSeconds
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.DEDUPLICATION_SCOPE =>
      val r = DeduplicationScope
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.FIFO_THROUGHPUT_LIMIT =>
      val r = FifoThroughputLimit
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.REDRIVE_ALLOW_POLICY =>
      val r = RedriveAllowPolicy
      r
    case software.amazon.awssdk.services.sqs.model.QueueAttributeName.SQS_MANAGED_SSE_ENABLED =>
      val r = SqsManagedSseEnabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.ALL
  }
  case object Policy extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.POLICY
  }
  case object VisibilityTimeout extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.VISIBILITY_TIMEOUT
  }
  case object MaximumMessageSize extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.MAXIMUM_MESSAGE_SIZE
  }
  case object MessageRetentionPeriod
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.MESSAGE_RETENTION_PERIOD
  }
  case object ApproximateNumberOfMessages
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES
  }
  case object ApproximateNumberOfMessagesNotVisible
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES_NOT_VISIBLE
  }
  case object CreatedTimestamp extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.CREATED_TIMESTAMP
  }
  case object LastModifiedTimestamp
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.LAST_MODIFIED_TIMESTAMP
  }
  case object QueueArn extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.QUEUE_ARN
  }
  case object ApproximateNumberOfMessagesDelayed
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES_DELAYED
  }
  case object DelaySeconds extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.DELAY_SECONDS
  }
  case object ReceiveMessageWaitTimeSeconds
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS
  }
  case object RedrivePolicy extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.REDRIVE_POLICY
  }
  case object FifoQueue extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.FIFO_QUEUE
  }
  case object ContentBasedDeduplication
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.CONTENT_BASED_DEDUPLICATION
  }
  case object KmsMasterKeyId extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.KMS_MASTER_KEY_ID
  }
  case object KmsDataKeyReusePeriodSeconds
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS
  }
  case object DeduplicationScope extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.DEDUPLICATION_SCOPE
  }
  case object FifoThroughputLimit extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.FIFO_THROUGHPUT_LIMIT
  }
  case object RedriveAllowPolicy extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.REDRIVE_ALLOW_POLICY
  }
  case object SqsManagedSseEnabled
      extends zio.aws.sqs.model.QueueAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.sqs.model.QueueAttributeName =
      software.amazon.awssdk.services.sqs.model.QueueAttributeName.SQS_MANAGED_SSE_ENABLED
  }
}
