package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sqs.model.primitives.{Integer, MessageAttributeName}
import scala.jdk.CollectionConverters.*
final case class ReceiveMessageRequest(
    queueUrl: String,
    attributeNames: Optional[Iterable[zio.aws.sqs.model.QueueAttributeName]] =
      Optional.Absent,
    messageAttributeNames: Optional[Iterable[MessageAttributeName]] =
      Optional.Absent,
    maxNumberOfMessages: Optional[Integer] = Optional.Absent,
    visibilityTimeout: Optional[Integer] = Optional.Absent,
    waitTimeSeconds: Optional[Integer] = Optional.Absent,
    receiveRequestAttemptId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest = {
    import ReceiveMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .optionallyWith(
        messageAttributeNames.map(value =>
          value.map { item =>
            MessageAttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.messageAttributeNames)
      .optionallyWith(
        maxNumberOfMessages.map(value => value: java.lang.Integer)
      )(_.maxNumberOfMessages)
      .optionallyWith(visibilityTimeout.map(value => value: java.lang.Integer))(
        _.visibilityTimeout
      )
      .optionallyWith(waitTimeSeconds.map(value => value: java.lang.Integer))(
        _.waitTimeSeconds
      )
      .optionallyWith(
        receiveRequestAttemptId.map(value => value: java.lang.String)
      )(_.receiveRequestAttemptId)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.ReceiveMessageRequest.ReadOnly =
    zio.aws.sqs.model.ReceiveMessageRequest.wrap(buildAwsValue())
}
object ReceiveMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.ReceiveMessageRequest =
      zio.aws.sqs.model.ReceiveMessageRequest(
        queueUrl,
        attributeNames.map(value => value),
        messageAttributeNames.map(value => value),
        maxNumberOfMessages.map(value => value),
        visibilityTimeout.map(value => value),
        waitTimeSeconds.map(value => value),
        receiveRequestAttemptId.map(value => value)
      )
    def queueUrl: String
    def attributeNames: Optional[List[zio.aws.sqs.model.QueueAttributeName]]
    def messageAttributeNames: Optional[List[MessageAttributeName]]
    def maxNumberOfMessages: Optional[Integer]
    def visibilityTimeout: Optional[Integer]
    def waitTimeSeconds: Optional[Integer]
    def receiveRequestAttemptId: Optional[String]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getAttributeNames
        : ZIO[Any, AwsError, List[zio.aws.sqs.model.QueueAttributeName]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
    def getMessageAttributeNames
        : ZIO[Any, AwsError, List[MessageAttributeName]] =
      AwsError.unwrapOptionField("messageAttributeNames", messageAttributeNames)
    def getMaxNumberOfMessages: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxNumberOfMessages", maxNumberOfMessages)
    def getVisibilityTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("visibilityTimeout", visibilityTimeout)
    def getWaitTimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("waitTimeSeconds", waitTimeSeconds)
    def getReceiveRequestAttemptId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("receiveRequestAttemptId", receiveRequestAttemptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest
  ) extends zio.aws.sqs.model.ReceiveMessageRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val attributeNames
        : Optional[List[zio.aws.sqs.model.QueueAttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sqs.model.QueueAttributeName.wrap(item)
          }.toList
        )
    override val messageAttributeNames: Optional[List[MessageAttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageAttributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sqs.model.primitives.MessageAttributeName(item)
          }.toList
        )
    override val maxNumberOfMessages: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxNumberOfMessages())
      .map(value => value: Integer)
    override val visibilityTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.visibilityTimeout())
      .map(value => value: Integer)
    override val waitTimeSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.waitTimeSeconds())
      .map(value => value: Integer)
    override val receiveRequestAttemptId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.receiveRequestAttemptId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest
  ): zio.aws.sqs.model.ReceiveMessageRequest.ReadOnly = new Wrapper(impl)
}
