package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendMessageBatchRequest(
    queueUrl: String,
    entries: Iterable[zio.aws.sqs.model.SendMessageBatchRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest = {
    import SendMessageBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest
      .builder()
      .queueUrl(queueUrl: java.lang.String)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SendMessageBatchRequest.ReadOnly =
    zio.aws.sqs.model.SendMessageBatchRequest.wrap(buildAwsValue())
}
object SendMessageBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SendMessageBatchRequest =
      zio.aws.sqs.model.SendMessageBatchRequest(
        queueUrl,
        entries.map { item =>
          item.asEditable
        }
      )
    def queueUrl: String
    def entries: List[zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly]
    def getQueueUrl: ZIO[Any, Nothing, String] = ZIO.succeed(queueUrl)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest
  ) extends zio.aws.sqs.model.SendMessageBatchRequest.ReadOnly {
    override val queueUrl: String = impl.queueUrl(): String
    override val entries
        : List[zio.aws.sqs.model.SendMessageBatchRequestEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.sqs.model.SendMessageBatchRequestEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest
  ): zio.aws.sqs.model.SendMessageBatchRequest.ReadOnly = new Wrapper(impl)
}
