package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendMessageBatchResponse(
    successful: Iterable[zio.aws.sqs.model.SendMessageBatchResultEntry],
    failed: Iterable[zio.aws.sqs.model.BatchResultErrorEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse = {
    import SendMessageBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse
      .builder()
      .successful(successful.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failed(failed.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly =
    zio.aws.sqs.model.SendMessageBatchResponse.wrap(buildAwsValue())
}
object SendMessageBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SendMessageBatchResponse =
      zio.aws.sqs.model.SendMessageBatchResponse(
        successful.map { item =>
          item.asEditable
        },
        failed.map { item =>
          item.asEditable
        }
      )
    def successful: List[zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly]
    def failed: List[zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly]
    def getSuccessful: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly
    ]] = ZIO.succeed(successful)
    def getFailed: ZIO[Any, Nothing, List[
      zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly
    ]] = ZIO.succeed(failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse
  ) extends zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly {
    override val successful
        : List[zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly] = impl
      .successful()
      .asScala
      .map { item =>
        zio.aws.sqs.model.SendMessageBatchResultEntry.wrap(item)
      }
      .toList
    override val failed
        : List[zio.aws.sqs.model.BatchResultErrorEntry.ReadOnly] = impl
      .failed()
      .asScala
      .map { item =>
        zio.aws.sqs.model.BatchResultErrorEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse
  ): zio.aws.sqs.model.SendMessageBatchResponse.ReadOnly = new Wrapper(impl)
}
