package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendMessageBatchResultEntry(
    id: String,
    messageId: String,
    md5OfMessageBody: String,
    md5OfMessageAttributes: Optional[String] = Optional.Absent,
    md5OfMessageSystemAttributes: Optional[String] = Optional.Absent,
    sequenceNumber: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry = {
    import SendMessageBatchResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry
      .builder()
      .id(id: java.lang.String)
      .messageId(messageId: java.lang.String)
      .md5OfMessageBody(md5OfMessageBody: java.lang.String)
      .optionallyWith(
        md5OfMessageAttributes.map(value => value: java.lang.String)
      )(_.md5OfMessageAttributes)
      .optionallyWith(
        md5OfMessageSystemAttributes.map(value => value: java.lang.String)
      )(_.md5OfMessageSystemAttributes)
      .optionallyWith(sequenceNumber.map(value => value: java.lang.String))(
        _.sequenceNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly =
    zio.aws.sqs.model.SendMessageBatchResultEntry.wrap(buildAwsValue())
}
object SendMessageBatchResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SendMessageBatchResultEntry =
      zio.aws.sqs.model.SendMessageBatchResultEntry(
        id,
        messageId,
        md5OfMessageBody,
        md5OfMessageAttributes.map(value => value),
        md5OfMessageSystemAttributes.map(value => value),
        sequenceNumber.map(value => value)
      )
    def id: String
    def messageId: String
    def md5OfMessageBody: String
    def md5OfMessageAttributes: Optional[String]
    def md5OfMessageSystemAttributes: Optional[String]
    def sequenceNumber: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getMessageId: ZIO[Any, Nothing, String] = ZIO.succeed(messageId)
    def getMd5OfMessageBody: ZIO[Any, Nothing, String] =
      ZIO.succeed(md5OfMessageBody)
    def getMd5OfMessageAttributes: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("md5OfMessageAttributes", md5OfMessageAttributes)
    def getMd5OfMessageSystemAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "md5OfMessageSystemAttributes",
        md5OfMessageSystemAttributes
      )
    def getSequenceNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry
  ) extends zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly {
    override val id: String = impl.id(): String
    override val messageId: String = impl.messageId(): String
    override val md5OfMessageBody: String = impl.md5OfMessageBody(): String
    override val md5OfMessageAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.md5OfMessageAttributes())
        .map(value => value: String)
    override val md5OfMessageSystemAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.md5OfMessageSystemAttributes())
        .map(value => value: String)
    override val sequenceNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sequenceNumber())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry
  ): zio.aws.sqs.model.SendMessageBatchResultEntry.ReadOnly = new Wrapper(impl)
}
