package zio.aws.sqs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendMessageResponse(
    md5OfMessageBody: Optional[String] = Optional.Absent,
    md5OfMessageAttributes: Optional[String] = Optional.Absent,
    md5OfMessageSystemAttributes: Optional[String] = Optional.Absent,
    messageId: Optional[String] = Optional.Absent,
    sequenceNumber: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sqs.model.SendMessageResponse = {
    import SendMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sqs.model.SendMessageResponse
      .builder()
      .optionallyWith(md5OfMessageBody.map(value => value: java.lang.String))(
        _.md5OfMessageBody
      )
      .optionallyWith(
        md5OfMessageAttributes.map(value => value: java.lang.String)
      )(_.md5OfMessageAttributes)
      .optionallyWith(
        md5OfMessageSystemAttributes.map(value => value: java.lang.String)
      )(_.md5OfMessageSystemAttributes)
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .optionallyWith(sequenceNumber.map(value => value: java.lang.String))(
        _.sequenceNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.sqs.model.SendMessageResponse.ReadOnly =
    zio.aws.sqs.model.SendMessageResponse.wrap(buildAwsValue())
}
object SendMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sqs.model.SendMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sqs.model.SendMessageResponse =
      zio.aws.sqs.model.SendMessageResponse(
        md5OfMessageBody.map(value => value),
        md5OfMessageAttributes.map(value => value),
        md5OfMessageSystemAttributes.map(value => value),
        messageId.map(value => value),
        sequenceNumber.map(value => value)
      )
    def md5OfMessageBody: Optional[String]
    def md5OfMessageAttributes: Optional[String]
    def md5OfMessageSystemAttributes: Optional[String]
    def messageId: Optional[String]
    def sequenceNumber: Optional[String]
    def getMd5OfMessageBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("md5OfMessageBody", md5OfMessageBody)
    def getMd5OfMessageAttributes: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("md5OfMessageAttributes", md5OfMessageAttributes)
    def getMd5OfMessageSystemAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "md5OfMessageSystemAttributes",
        md5OfMessageSystemAttributes
      )
    def getMessageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getSequenceNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageResponse
  ) extends zio.aws.sqs.model.SendMessageResponse.ReadOnly {
    override val md5OfMessageBody: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.md5OfMessageBody())
      .map(value => value: String)
    override val md5OfMessageAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.md5OfMessageAttributes())
        .map(value => value: String)
    override val md5OfMessageSystemAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.md5OfMessageSystemAttributes())
        .map(value => value: String)
    override val messageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: String)
    override val sequenceNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sequenceNumber())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sqs.model.SendMessageResponse
  ): zio.aws.sqs.model.SendMessageResponse.ReadOnly = new Wrapper(impl)
}
