package zio.aws.sqs
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.sqs.model.primitives.{
  TagValue,
  TagKey,
  MessageAttributeName,
  Binary
}
import zio.aws.sqs.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Binary extends Subtype[Chunk[Byte]]
    type Binary = zio.aws.sqs.model.primitives.Binary.Type
    type BoxedInteger = Int
    type Integer = Int
    object MessageAttributeName extends Subtype[String]
    type MessageAttributeName =
      zio.aws.sqs.model.primitives.MessageAttributeName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.sqs.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.sqs.model.primitives.TagValue.Type
    object Token extends Subtype[String]
    type Token = zio.aws.sqs.model.primitives.Token.Type
  }
  type AWSAccountIdList = List[String]
  type ActionNameList = List[String]
  type AttributeNameList = List[zio.aws.sqs.model.QueueAttributeName]
  type BatchResultErrorEntryList = List[zio.aws.sqs.model.BatchResultErrorEntry]
  type BinaryList = List[Binary]
  type ChangeMessageVisibilityBatchRequestEntryList =
    List[zio.aws.sqs.model.ChangeMessageVisibilityBatchRequestEntry]
  type ChangeMessageVisibilityBatchResultEntryList =
    List[zio.aws.sqs.model.ChangeMessageVisibilityBatchResultEntry]
  type DeleteMessageBatchRequestEntryList =
    List[zio.aws.sqs.model.DeleteMessageBatchRequestEntry]
  type DeleteMessageBatchResultEntryList =
    List[zio.aws.sqs.model.DeleteMessageBatchResultEntry]
  type MessageAttributeNameList = List[MessageAttributeName]
  type MessageBodyAttributeMap =
    Map[String, zio.aws.sqs.model.MessageAttributeValue]
  type MessageBodySystemAttributeMap = Map[
    zio.aws.sqs.model.MessageSystemAttributeNameForSends,
    zio.aws.sqs.model.MessageSystemAttributeValue
  ]
  type MessageList = List[zio.aws.sqs.model.Message]
  type MessageSystemAttributeMap =
    Map[zio.aws.sqs.model.MessageSystemAttributeName, String]
  type QueueAttributeMap = Map[zio.aws.sqs.model.QueueAttributeName, String]
  type QueueUrlList = List[String]
  type SendMessageBatchRequestEntryList =
    List[zio.aws.sqs.model.SendMessageBatchRequestEntry]
  type SendMessageBatchResultEntryList =
    List[zio.aws.sqs.model.SendMessageBatchResultEntry]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
