package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  SerialNumberType,
  ArnType,
  TokenCodeType,
  SourceIdentityType,
  TagKeyType,
  RoleSessionNameType,
  ExternalIdType,
  RoleDurationSecondsType,
  UnrestrictedSessionPolicyDocumentType
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssumeRoleRequest(
    roleArn: ArnType,
    roleSessionName: RoleSessionNameType,
    policyArns: Optional[Iterable[zio.aws.sts.model.PolicyDescriptorType]] =
      Optional.Absent,
    policy: Optional[UnrestrictedSessionPolicyDocumentType] = Optional.Absent,
    durationSeconds: Optional[RoleDurationSecondsType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sts.model.Tag]] = Optional.Absent,
    transitiveTagKeys: Optional[Iterable[TagKeyType]] = Optional.Absent,
    externalId: Optional[ExternalIdType] = Optional.Absent,
    serialNumber: Optional[SerialNumberType] = Optional.Absent,
    tokenCode: Optional[TokenCodeType] = Optional.Absent,
    sourceIdentity: Optional[SourceIdentityType] = Optional.Absent,
    providedContexts: Optional[Iterable[zio.aws.sts.model.ProvidedContext]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleRequest = {
    import AssumeRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleRequest
      .builder()
      .roleArn(ArnType.unwrap(roleArn): java.lang.String)
      .roleSessionName(
        RoleSessionNameType.unwrap(roleSessionName): java.lang.String
      )
      .optionallyWith(
        policyArns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyArns)
      .optionallyWith(
        policy.map(value =>
          UnrestrictedSessionPolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.policy)
      .optionallyWith(
        durationSeconds.map(value =>
          RoleDurationSecondsType.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        transitiveTagKeys.map(value =>
          value.map { item =>
            TagKeyType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitiveTagKeys)
      .optionallyWith(
        externalId.map(value => ExternalIdType.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        serialNumber.map(value =>
          SerialNumberType.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(
        tokenCode.map(value => TokenCodeType.unwrap(value): java.lang.String)
      )(_.tokenCode)
      .optionallyWith(
        sourceIdentity.map(value =>
          SourceIdentityType.unwrap(value): java.lang.String
        )
      )(_.sourceIdentity)
      .optionallyWith(
        providedContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.providedContexts)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleRequest.ReadOnly =
    zio.aws.sts.model.AssumeRoleRequest.wrap(buildAwsValue())
}
object AssumeRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleRequest =
      zio.aws.sts.model.AssumeRoleRequest(
        roleArn,
        roleSessionName,
        policyArns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        durationSeconds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transitiveTagKeys.map(value => value),
        externalId.map(value => value),
        serialNumber.map(value => value),
        tokenCode.map(value => value),
        sourceIdentity.map(value => value),
        providedContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def roleArn: ArnType
    def roleSessionName: RoleSessionNameType
    def policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]]
    def policy: Optional[UnrestrictedSessionPolicyDocumentType]
    def durationSeconds: Optional[RoleDurationSecondsType]
    def tags: Optional[List[zio.aws.sts.model.Tag.ReadOnly]]
    def transitiveTagKeys: Optional[List[TagKeyType]]
    def externalId: Optional[ExternalIdType]
    def serialNumber: Optional[SerialNumberType]
    def tokenCode: Optional[TokenCodeType]
    def sourceIdentity: Optional[SourceIdentityType]
    def providedContexts
        : Optional[List[zio.aws.sts.model.ProvidedContext.ReadOnly]]
    def getRoleArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(roleArn)
    def getRoleSessionName: ZIO[Any, Nothing, RoleSessionNameType] =
      ZIO.succeed(roleSessionName)
    def getPolicyArns: ZIO[Any, AwsError, List[
      zio.aws.sts.model.PolicyDescriptorType.ReadOnly
    ]] = AwsError.unwrapOptionField("policyArns", policyArns)
    def getPolicy: ZIO[Any, AwsError, UnrestrictedSessionPolicyDocumentType] =
      AwsError.unwrapOptionField("policy", policy)
    def getDurationSeconds: ZIO[Any, AwsError, RoleDurationSecondsType] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sts.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTransitiveTagKeys: ZIO[Any, AwsError, List[TagKeyType]] =
      AwsError.unwrapOptionField("transitiveTagKeys", transitiveTagKeys)
    def getExternalId: ZIO[Any, AwsError, ExternalIdType] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getSerialNumber: ZIO[Any, AwsError, SerialNumberType] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getTokenCode: ZIO[Any, AwsError, TokenCodeType] =
      AwsError.unwrapOptionField("tokenCode", tokenCode)
    def getSourceIdentity: ZIO[Any, AwsError, SourceIdentityType] =
      AwsError.unwrapOptionField("sourceIdentity", sourceIdentity)
    def getProvidedContexts
        : ZIO[Any, AwsError, List[zio.aws.sts.model.ProvidedContext.ReadOnly]] =
      AwsError.unwrapOptionField("providedContexts", providedContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleRequest
  ) extends zio.aws.sts.model.AssumeRoleRequest.ReadOnly {
    override val roleArn: ArnType =
      zio.aws.sts.model.primitives.ArnType(impl.roleArn())
    override val roleSessionName: RoleSessionNameType =
      zio.aws.sts.model.primitives.RoleSessionNameType(impl.roleSessionName())
    override val policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.PolicyDescriptorType.wrap(item)
          }.toList
        )
    override val policy: Optional[UnrestrictedSessionPolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.sts.model.primitives
            .UnrestrictedSessionPolicyDocumentType(value)
        )
    override val durationSeconds: Optional[RoleDurationSecondsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.sts.model.primitives.RoleDurationSecondsType(value)
        )
    override val tags: Optional[List[zio.aws.sts.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.Tag.wrap(item)
          }.toList
        )
    override val transitiveTagKeys: Optional[List[TagKeyType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitiveTagKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.primitives.TagKeyType(item)
          }.toList
        )
    override val externalId: Optional[ExternalIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.sts.model.primitives.ExternalIdType(value))
    override val serialNumber: Optional[SerialNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value => zio.aws.sts.model.primitives.SerialNumberType(value))
    override val tokenCode: Optional[TokenCodeType] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenCode())
      .map(value => zio.aws.sts.model.primitives.TokenCodeType(value))
    override val sourceIdentity: Optional[SourceIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIdentity())
        .map(value => zio.aws.sts.model.primitives.SourceIdentityType(value))
    override val providedContexts
        : Optional[List[zio.aws.sts.model.ProvidedContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providedContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.ProvidedContext.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleRequest
  ): zio.aws.sts.model.AssumeRoleRequest.ReadOnly = new Wrapper(impl)
}
