package zio.aws.sts.model
import zio.aws.sts.model.primitives.{
  DateType,
  TokenType,
  AccessKeySecretType,
  AccessKeyIdType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Credentials(
    accessKeyId: AccessKeyIdType,
    secretAccessKey: AccessKeySecretType,
    sessionToken: TokenType,
    expiration: DateType
) {
  def buildAwsValue(): software.amazon.awssdk.services.sts.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.Credentials
      .builder()
      .accessKeyId(AccessKeyIdType.unwrap(accessKeyId): java.lang.String)
      .secretAccessKey(
        AccessKeySecretType.unwrap(secretAccessKey): java.lang.String
      )
      .sessionToken(TokenType.unwrap(sessionToken): java.lang.String)
      .expiration(DateType.unwrap(expiration): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.Credentials.ReadOnly =
    zio.aws.sts.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sts.model.Credentials] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.Credentials = zio.aws.sts.model
      .Credentials(accessKeyId, secretAccessKey, sessionToken, expiration)
    def accessKeyId: AccessKeyIdType
    def secretAccessKey: AccessKeySecretType
    def sessionToken: TokenType
    def expiration: DateType
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyIdType] =
      ZIO.succeed(accessKeyId)
    def getSecretAccessKey: ZIO[Any, Nothing, AccessKeySecretType] =
      ZIO.succeed(secretAccessKey)
    def getSessionToken: ZIO[Any, Nothing, TokenType] =
      ZIO.succeed(sessionToken)
    def getExpiration: ZIO[Any, Nothing, DateType] = ZIO.succeed(expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.Credentials
  ) extends zio.aws.sts.model.Credentials.ReadOnly {
    override val accessKeyId: AccessKeyIdType =
      zio.aws.sts.model.primitives.AccessKeyIdType(impl.accessKeyId())
    override val secretAccessKey: AccessKeySecretType =
      zio.aws.sts.model.primitives.AccessKeySecretType(impl.secretAccessKey())
    override val sessionToken: TokenType =
      zio.aws.sts.model.primitives.TokenType(impl.sessionToken())
    override val expiration: DateType =
      zio.aws.sts.model.primitives.DateType(impl.expiration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.Credentials
  ): zio.aws.sts.model.Credentials.ReadOnly = new Wrapper(impl)
}
