package zio.aws.sts
import zio.aws.sts.model.AssumeRoleResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.sts.StsAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sts.model.{
  GetAccessKeyInfoRequest,
  AssumeRoleRequest,
  DecodeAuthorizationMessageRequest,
  GetFederationTokenRequest,
  AssumeRoleWithSamlRequest,
  GetCallerIdentityRequest,
  AssumeRoleWithWebIdentityRequest,
  GetSessionTokenRequest
}
object StsMock extends Mock[Sts] {
  object AssumeRole extends Effect[AssumeRoleRequest, AwsError, ReadOnly]
  object GetCallerIdentity
      extends Effect[
        GetCallerIdentityRequest,
        AwsError,
        zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly
      ]
  object AssumeRoleWithWebIdentity
      extends Effect[
        AssumeRoleWithWebIdentityRequest,
        AwsError,
        zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly
      ]
  object GetSessionToken
      extends Effect[
        GetSessionTokenRequest,
        AwsError,
        zio.aws.sts.model.GetSessionTokenResponse.ReadOnly
      ]
  object GetFederationToken
      extends Effect[
        GetFederationTokenRequest,
        AwsError,
        zio.aws.sts.model.GetFederationTokenResponse.ReadOnly
      ]
  object DecodeAuthorizationMessage
      extends Effect[
        DecodeAuthorizationMessageRequest,
        AwsError,
        zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly
      ]
  object GetAccessKeyInfo
      extends Effect[
        GetAccessKeyInfoRequest,
        AwsError,
        zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly
      ]
  object AssumeRoleWithSAML
      extends Effect[
        AssumeRoleWithSamlRequest,
        AwsError,
        zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Sts] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sts] { rts =>
        zio.ZIO.succeed {
          new Sts {
            val api: StsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sts = this
            def assumeRole(request: AssumeRoleRequest): IO[AwsError, ReadOnly] =
              proxy(AssumeRole, request)
            def getCallerIdentity(request: GetCallerIdentityRequest): IO[
              AwsError,
              zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly
            ] = proxy(GetCallerIdentity, request)
            def assumeRoleWithWebIdentity(
                request: AssumeRoleWithWebIdentityRequest
            ): IO[
              AwsError,
              zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly
            ] = proxy(AssumeRoleWithWebIdentity, request)
            def getSessionToken(request: GetSessionTokenRequest): IO[
              AwsError,
              zio.aws.sts.model.GetSessionTokenResponse.ReadOnly
            ] = proxy(GetSessionToken, request)
            def getFederationToken(request: GetFederationTokenRequest): IO[
              AwsError,
              zio.aws.sts.model.GetFederationTokenResponse.ReadOnly
            ] = proxy(GetFederationToken, request)
            def decodeAuthorizationMessage(
                request: DecodeAuthorizationMessageRequest
            ): IO[
              AwsError,
              zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly
            ] = proxy(DecodeAuthorizationMessage, request)
            def getAccessKeyInfo(request: GetAccessKeyInfoRequest): IO[
              AwsError,
              zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly
            ] = proxy(GetAccessKeyInfo, request)
            def assumeRoleWithSAML(request: AssumeRoleWithSamlRequest): IO[
              AwsError,
              zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly
            ] = proxy(AssumeRoleWithSAML, request)
          }
        }
      }
    }
  }
}
