package zio.aws.sts.model
import zio.aws.sts.model.primitives.{ContextAssertionType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvidedContext(
    providerArn: Optional[ArnType] = Optional.Absent,
    contextAssertion: Optional[ContextAssertionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.ProvidedContext = {
    import ProvidedContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.ProvidedContext
      .builder()
      .optionallyWith(
        providerArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.providerArn)
      .optionallyWith(
        contextAssertion.map(value =>
          ContextAssertionType.unwrap(value): java.lang.String
        )
      )(_.contextAssertion)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.ProvidedContext.ReadOnly =
    zio.aws.sts.model.ProvidedContext.wrap(buildAwsValue())
}
object ProvidedContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.ProvidedContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.ProvidedContext =
      zio.aws.sts.model.ProvidedContext(
        providerArn.map(value => value),
        contextAssertion.map(value => value)
      )
    def providerArn: Optional[ArnType]
    def contextAssertion: Optional[ContextAssertionType]
    def getProviderArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("providerArn", providerArn)
    def getContextAssertion: ZIO[Any, AwsError, ContextAssertionType] =
      AwsError.unwrapOptionField("contextAssertion", contextAssertion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.ProvidedContext
  ) extends zio.aws.sts.model.ProvidedContext.ReadOnly {
    override val providerArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.providerArn())
      .map(value => zio.aws.sts.model.primitives.ArnType(value))
    override val contextAssertion: Optional[ContextAssertionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextAssertion())
        .map(value => zio.aws.sts.model.primitives.ContextAssertionType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.ProvidedContext
  ): zio.aws.sts.model.ProvidedContext.ReadOnly = new Wrapper(impl)
}
