package zio.aws.workdocs
import zio.aws.workdocs.model.AddResourcePermissionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.workdocs.model.{
  DescribeNotificationSubscriptionsRequest,
  DeleteUserRequest,
  RemoveAllResourcePermissionsRequest,
  CreateCommentRequest,
  DeleteFolderRequest,
  DeleteCommentRequest,
  GetCurrentUserRequest,
  DescribeFolderContentsRequest,
  DescribeUsersRequest,
  DescribeResourcePermissionsRequest,
  DeleteLabelsRequest,
  AbortDocumentVersionUploadRequest,
  DescribeGroupsRequest,
  CreateLabelsRequest,
  CreateCustomMetadataRequest,
  UpdateFolderRequest,
  AddResourcePermissionsRequest,
  UpdateDocumentRequest,
  DeactivateUserRequest,
  CreateUserRequest,
  GetFolderRequest,
  ActivateUserRequest,
  DescribeCommentsRequest,
  RemoveResourcePermissionRequest,
  DescribeDocumentVersionsRequest,
  DescribeActivitiesRequest,
  UpdateDocumentVersionRequest,
  DeleteNotificationSubscriptionRequest,
  DeleteDocumentRequest,
  DescribeRootFoldersRequest,
  DeleteFolderContentsRequest,
  UpdateUserRequest,
  GetDocumentPathRequest,
  GetDocumentRequest,
  GetFolderPathRequest,
  InitiateDocumentVersionUploadRequest,
  DeleteCustomMetadataRequest,
  GetResourcesRequest,
  CreateNotificationSubscriptionRequest,
  GetDocumentVersionRequest,
  CreateFolderRequest
}
import zio.stream.ZStream
object WorkDocsMock extends Mock[WorkDocs] {
  object GetDocumentPath
      extends Effect[
        GetDocumentPathRequest,
        AwsError,
        zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly
      ]
  object CreateLabels
      extends Effect[
        CreateLabelsRequest,
        AwsError,
        zio.aws.workdocs.model.CreateLabelsResponse.ReadOnly
      ]
  object GetCurrentUser
      extends Effect[
        GetCurrentUserRequest,
        AwsError,
        zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.workdocs.model.UpdateUserResponse.ReadOnly
      ]
  object GetFolderPath
      extends Effect[
        GetFolderPathRequest,
        AwsError,
        zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly
      ]
  object RemoveAllResourcePermissions
      extends Effect[RemoveAllResourcePermissionsRequest, AwsError, Unit]
  object ActivateUser
      extends Effect[
        ActivateUserRequest,
        AwsError,
        zio.aws.workdocs.model.ActivateUserResponse.ReadOnly
      ]
  object CreateNotificationSubscription
      extends Effect[
        CreateNotificationSubscriptionRequest,
        AwsError,
        zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly
      ]
  object AbortDocumentVersionUpload
      extends Effect[AbortDocumentVersionUploadRequest, AwsError, Unit]
  object DescribeActivities
      extends Effect[
        DescribeActivitiesRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly
      ]
  object DeleteComment extends Effect[DeleteCommentRequest, AwsError, Unit]
  object GetDocument
      extends Effect[
        GetDocumentRequest,
        AwsError,
        zio.aws.workdocs.model.GetDocumentResponse.ReadOnly
      ]
  object DescribeResourcePermissions
      extends Effect[
        DescribeResourcePermissionsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly
      ]
  object DeleteFolderContents
      extends Effect[DeleteFolderContentsRequest, AwsError, Unit]
  object DeleteFolder extends Effect[DeleteFolderRequest, AwsError, Unit]
  object DeleteLabels
      extends Effect[
        DeleteLabelsRequest,
        AwsError,
        zio.aws.workdocs.model.DeleteLabelsResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.workdocs.model.CreateUserResponse.ReadOnly
      ]
  object GetFolder
      extends Effect[
        GetFolderRequest,
        AwsError,
        zio.aws.workdocs.model.GetFolderResponse.ReadOnly
      ]
  object DescribeRootFolders
      extends Effect[
        DescribeRootFoldersRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly
      ]
  object CreateComment
      extends Effect[
        CreateCommentRequest,
        AwsError,
        zio.aws.workdocs.model.CreateCommentResponse.ReadOnly
      ]
  object GetResources
      extends Effect[
        GetResourcesRequest,
        AwsError,
        zio.aws.workdocs.model.GetResourcesResponse.ReadOnly
      ]
  object AddResourcePermissions
      extends Effect[AddResourcePermissionsRequest, AwsError, ReadOnly]
  object DescribeUsers
      extends Stream[
        DescribeUsersRequest,
        AwsError,
        zio.aws.workdocs.model.User.ReadOnly
      ]
  object DescribeUsersPaginated
      extends Effect[
        DescribeUsersRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly
      ]
  object UpdateDocument extends Effect[UpdateDocumentRequest, AwsError, Unit]
  object DescribeNotificationSubscriptions
      extends Effect[
        DescribeNotificationSubscriptionsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly
      ]
  object CreateCustomMetadata
      extends Effect[
        CreateCustomMetadataRequest,
        AwsError,
        zio.aws.workdocs.model.CreateCustomMetadataResponse.ReadOnly
      ]
  object DeleteCustomMetadata
      extends Effect[
        DeleteCustomMetadataRequest,
        AwsError,
        zio.aws.workdocs.model.DeleteCustomMetadataResponse.ReadOnly
      ]
  object DescribeComments
      extends Effect[
        DescribeCommentsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly
      ]
  object DescribeGroups
      extends Effect[
        DescribeGroupsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly
      ]
  object InitiateDocumentVersionUpload
      extends Effect[
        InitiateDocumentVersionUploadRequest,
        AwsError,
        zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly
      ]
  object DescribeFolderContents
      extends Stream[
        DescribeFolderContentsRequest,
        AwsError,
        zio.aws.workdocs.model.FolderMetadata.ReadOnly
      ]
  object DescribeFolderContentsPaginated
      extends Effect[
        DescribeFolderContentsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly
      ]
  object UpdateFolder extends Effect[UpdateFolderRequest, AwsError, Unit]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object UpdateDocumentVersion
      extends Effect[UpdateDocumentVersionRequest, AwsError, Unit]
  object CreateFolder
      extends Effect[
        CreateFolderRequest,
        AwsError,
        zio.aws.workdocs.model.CreateFolderResponse.ReadOnly
      ]
  object GetDocumentVersion
      extends Effect[
        GetDocumentVersionRequest,
        AwsError,
        zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly
      ]
  object RemoveResourcePermission
      extends Effect[RemoveResourcePermissionRequest, AwsError, Unit]
  object DeleteNotificationSubscription
      extends Effect[DeleteNotificationSubscriptionRequest, AwsError, Unit]
  object DeleteDocument extends Effect[DeleteDocumentRequest, AwsError, Unit]
  object DescribeDocumentVersions
      extends Stream[
        DescribeDocumentVersionsRequest,
        AwsError,
        zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
      ]
  object DescribeDocumentVersionsPaginated
      extends Effect[
        DescribeDocumentVersionsRequest,
        AwsError,
        zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly
      ]
  object DeactivateUser extends Effect[DeactivateUserRequest, AwsError, Unit]
  val compose: URLayer[Proxy, WorkDocs] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new WorkDocs {
          val api: WorkDocsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : WorkDocs = this
          def getDocumentPath(request: GetDocumentPathRequest): IO[
            AwsError,
            zio.aws.workdocs.model.GetDocumentPathResponse.ReadOnly
          ] = proxy(GetDocumentPath, request)
          def createLabels(request: CreateLabelsRequest): IO[
            AwsError,
            zio.aws.workdocs.model.CreateLabelsResponse.ReadOnly
          ] = proxy(CreateLabels, request)
          def getCurrentUser(request: GetCurrentUserRequest): IO[
            AwsError,
            zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly
          ] = proxy(GetCurrentUser, request)
          def updateUser(
              request: UpdateUserRequest
          ): IO[AwsError, zio.aws.workdocs.model.UpdateUserResponse.ReadOnly] =
            proxy(UpdateUser, request)
          def getFolderPath(request: GetFolderPathRequest): IO[
            AwsError,
            zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly
          ] = proxy(GetFolderPath, request)
          def removeAllResourcePermissions(
              request: RemoveAllResourcePermissionsRequest
          ): IO[AwsError, Unit] = proxy(RemoveAllResourcePermissions, request)
          def activateUser(request: ActivateUserRequest): IO[
            AwsError,
            zio.aws.workdocs.model.ActivateUserResponse.ReadOnly
          ] = proxy(ActivateUser, request)
          def createNotificationSubscription(
              request: CreateNotificationSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.CreateNotificationSubscriptionResponse.ReadOnly
          ] = proxy(CreateNotificationSubscription, request)
          def abortDocumentVersionUpload(
              request: AbortDocumentVersionUploadRequest
          ): IO[AwsError, Unit] = proxy(AbortDocumentVersionUpload, request)
          def describeActivities(request: DescribeActivitiesRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly
          ] = proxy(DescribeActivities, request)
          def deleteComment(request: DeleteCommentRequest): IO[AwsError, Unit] =
            proxy(DeleteComment, request)
          def getDocument(
              request: GetDocumentRequest
          ): IO[AwsError, zio.aws.workdocs.model.GetDocumentResponse.ReadOnly] =
            proxy(GetDocument, request)
          def describeResourcePermissions(
              request: DescribeResourcePermissionsRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeResourcePermissionsResponse.ReadOnly
          ] = proxy(DescribeResourcePermissions, request)
          def deleteFolderContents(
              request: DeleteFolderContentsRequest
          ): IO[AwsError, Unit] = proxy(DeleteFolderContents, request)
          def deleteFolder(request: DeleteFolderRequest): IO[AwsError, Unit] =
            proxy(DeleteFolder, request)
          def deleteLabels(request: DeleteLabelsRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DeleteLabelsResponse.ReadOnly
          ] = proxy(DeleteLabels, request)
          def createUser(
              request: CreateUserRequest
          ): IO[AwsError, zio.aws.workdocs.model.CreateUserResponse.ReadOnly] =
            proxy(CreateUser, request)
          def getFolder(
              request: GetFolderRequest
          ): IO[AwsError, zio.aws.workdocs.model.GetFolderResponse.ReadOnly] =
            proxy(GetFolder, request)
          def describeRootFolders(request: DescribeRootFoldersRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeRootFoldersResponse.ReadOnly
          ] = proxy(DescribeRootFolders, request)
          def createComment(request: CreateCommentRequest): IO[
            AwsError,
            zio.aws.workdocs.model.CreateCommentResponse.ReadOnly
          ] = proxy(CreateComment, request)
          def getResources(request: GetResourcesRequest): IO[
            AwsError,
            zio.aws.workdocs.model.GetResourcesResponse.ReadOnly
          ] = proxy(GetResources, request)
          def addResourcePermissions(
              request: AddResourcePermissionsRequest
          ): IO[AwsError, ReadOnly] = proxy(AddResourcePermissions, request)
          def describeUsers(
              request: DescribeUsersRequest
          ): ZStream[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
            rts.unsafeRun(proxy(DescribeUsers, request))
          def describeUsersPaginated(request: DescribeUsersRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeUsersResponse.ReadOnly
          ] = proxy(DescribeUsersPaginated, request)
          def updateDocument(
              request: UpdateDocumentRequest
          ): IO[AwsError, Unit] = proxy(UpdateDocument, request)
          def describeNotificationSubscriptions(
              request: DescribeNotificationSubscriptionsRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly
          ] = proxy(DescribeNotificationSubscriptions, request)
          def createCustomMetadata(request: CreateCustomMetadataRequest): IO[
            AwsError,
            zio.aws.workdocs.model.CreateCustomMetadataResponse.ReadOnly
          ] = proxy(CreateCustomMetadata, request)
          def deleteCustomMetadata(request: DeleteCustomMetadataRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DeleteCustomMetadataResponse.ReadOnly
          ] = proxy(DeleteCustomMetadata, request)
          def describeComments(request: DescribeCommentsRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeCommentsResponse.ReadOnly
          ] = proxy(DescribeComments, request)
          def describeGroups(request: DescribeGroupsRequest): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly
          ] = proxy(DescribeGroups, request)
          def initiateDocumentVersionUpload(
              request: InitiateDocumentVersionUploadRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly
          ] = proxy(InitiateDocumentVersionUpload, request)
          def describeFolderContents(
              request: DescribeFolderContentsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workdocs.model.FolderMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeFolderContents, request))
          def describeFolderContentsPaginated(
              request: DescribeFolderContentsRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly
          ] = proxy(DescribeFolderContentsPaginated, request)
          def updateFolder(request: UpdateFolderRequest): IO[AwsError, Unit] =
            proxy(UpdateFolder, request)
          def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
            proxy(DeleteUser, request)
          def updateDocumentVersion(
              request: UpdateDocumentVersionRequest
          ): IO[AwsError, Unit] = proxy(UpdateDocumentVersion, request)
          def createFolder(request: CreateFolderRequest): IO[
            AwsError,
            zio.aws.workdocs.model.CreateFolderResponse.ReadOnly
          ] = proxy(CreateFolder, request)
          def getDocumentVersion(request: GetDocumentVersionRequest): IO[
            AwsError,
            zio.aws.workdocs.model.GetDocumentVersionResponse.ReadOnly
          ] = proxy(GetDocumentVersion, request)
          def removeResourcePermission(
              request: RemoveResourcePermissionRequest
          ): IO[AwsError, Unit] = proxy(RemoveResourcePermission, request)
          def deleteNotificationSubscription(
              request: DeleteNotificationSubscriptionRequest
          ): IO[AwsError, Unit] = proxy(DeleteNotificationSubscription, request)
          def deleteDocument(
              request: DeleteDocumentRequest
          ): IO[AwsError, Unit] = proxy(DeleteDocument, request)
          def describeDocumentVersions(
              request: DescribeDocumentVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDocumentVersions, request))
          def describeDocumentVersionsPaginated(
              request: DescribeDocumentVersionsRequest
          ): IO[
            AwsError,
            zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly
          ] = proxy(DescribeDocumentVersionsPaginated, request)
          def deactivateUser(
              request: DeactivateUserRequest
          ): IO[AwsError, Unit] = proxy(DeactivateUser, request)
        }
      }
    }
    .toLayer
}
